/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;

class EncryptionExtensionIdentifier {
    private static final String ENCRYPTION_EXTENSION_PUBLISHER = "Microsoft.Azure.Security";
    private static final String LINUX_LEGACY_ENCRYPTION_EXTENSION_VERSION = "0.1";
    private static final String LINUX_NOAAD_ENCRYPTION_EXTENSION_VERSION = "1.1";
    private static final String WINDOWS_LEGACY_ENCRYPTION_EXTENSION_VERSION = "1.1";
    private static final String WINDOWS_NOAAD_ENCRYPTION_EXTENSION_VERSION = "2.2";
    private static final String LINUX_ENCRYPTION_TYPE_NAME = "AzureDiskEncryptionForLinux";
    private static final String WINDOWS_ENCRYPTION_TYPE_NAME = "AzureDiskEncryption";

    EncryptionExtensionIdentifier() {
    }

    static String publisherName() {
        return ENCRYPTION_EXTENSION_PUBLISHER;
    }

    static String typeName(OperatingSystemTypes osType) {
        if (osType == OperatingSystemTypes.LINUX) {
            return LINUX_ENCRYPTION_TYPE_NAME;
        }
        return WINDOWS_ENCRYPTION_TYPE_NAME;
    }

    static String version(OperatingSystemTypes osType, boolean isNoAAD) {
        if (osType == OperatingSystemTypes.LINUX) {
            return isNoAAD ? "1.1" : LINUX_LEGACY_ENCRYPTION_EXTENSION_VERSION;
        }
        return isNoAAD ? WINDOWS_NOAAD_ENCRYPTION_EXTENSION_VERSION : "1.1";
    }

    static boolean isNoAADVersion(OperatingSystemTypes osType, String version) {
        String majorVersion = version.split("\\.")[0];
        if (osType == OperatingSystemTypes.LINUX) {
            return majorVersion.equals("1.1".split("\\.")[0]);
        }
        return majorVersion.equals(WINDOWS_NOAAD_ENCRYPTION_EXTENSION_VERSION.split("\\.")[0]);
    }

    static boolean isEncryptionPublisherName(String publisherName) {
        return publisherName.equalsIgnoreCase(EncryptionExtensionIdentifier.publisherName());
    }

    static boolean isEncryptionTypeName(String typeName, OperatingSystemTypes osType) {
        return typeName.equalsIgnoreCase(EncryptionExtensionIdentifier.typeName(osType));
    }
}

