/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.SnapshotInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AccessLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CopyCompletionError;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GrantAccessData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Snapshot;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SnapshotSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SnapshotSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.util.Objects;

class SnapshotImpl
extends GroupableResourceImpl<Snapshot, SnapshotInner, SnapshotImpl, ComputeManager>
implements Snapshot,
Snapshot.Definition,
Snapshot.Update {
    private final ClientLogger logger = new ClientLogger(SnapshotImpl.class);

    SnapshotImpl(String name, SnapshotInner innerModel, ComputeManager computeManager) {
        super(name, innerModel, computeManager);
    }

    @Override
    public SnapshotSkuType skuType() {
        if (((SnapshotInner)this.innerModel()).sku() == null) {
            return null;
        }
        return SnapshotSkuType.fromSnapshotSku(((SnapshotInner)this.innerModel()).sku());
    }

    @Override
    public DiskCreateOption creationMethod() {
        return ((SnapshotInner)this.innerModel()).creationData().createOption();
    }

    @Override
    public boolean incremental() {
        return ((SnapshotInner)this.innerModel()).incremental();
    }

    @Override
    public int sizeInGB() {
        return ResourceManagerUtils.toPrimitiveInt(((SnapshotInner)this.innerModel()).diskSizeGB());
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((SnapshotInner)this.innerModel()).osType();
    }

    @Override
    public CreationSource source() {
        return new CreationSource(((SnapshotInner)this.innerModel()).creationData());
    }

    @Override
    public Float copyCompletionPercent() {
        return ((SnapshotInner)this.innerModel()).completionPercent();
    }

    @Override
    public CopyCompletionError copyCompletionError() {
        return ((SnapshotInner)this.innerModel()).copyCompletionError();
    }

    @Override
    public String grantAccess(int accessDurationInSeconds) {
        return this.grantAccessAsync(accessDurationInSeconds).block();
    }

    @Override
    public Mono<String> grantAccessAsync(int accessDurationInSeconds) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(AccessLevel.READ).withDurationInSeconds(accessDurationInSeconds);
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().grantAccessAsync(this.resourceGroupName(), this.name(), grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public void revokeAccess() {
        this.revokeAccessAsync().block();
    }

    @Override
    public Mono<Void> revokeAccessAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().revokeAccessAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void awaitCopyStartCompletion() {
        this.awaitCopyStartCompletionAsync().block();
    }

    @Override
    public Boolean awaitCopyStartCompletion(Duration maxWaitTime) {
        Objects.requireNonNull(maxWaitTime);
        if (maxWaitTime.isNegative() || maxWaitTime.isZero()) {
            throw new IllegalArgumentException(String.format("Max wait time is non-positive: %dms", maxWaitTime.toMillis()));
        }
        return this.awaitCopyStartCompletionAsync().then(Mono.just(Boolean.TRUE)).timeout(maxWaitTime, Mono.just(Boolean.FALSE)).block();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return ((SnapshotInner)this.innerModel()).publicNetworkAccess();
    }

    @Override
    public Mono<Void> awaitCopyStartCompletionAsync() {
        if (this.creationMethod() != DiskCreateOption.COPY_START) {
            return Mono.error(this.logger.logThrowableAsError(new IllegalStateException(String.format("\"awaitCopyStartCompletionAsync\" cannot be called on snapshot \"%s\" when \"creationMethod\" is not \"CopyStart\"", this.name()))));
        }
        return Flux.interval(Duration.ZERO, ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval())).flatMap(ignored -> this.getInnerAsync()).flatMap(inner -> {
            this.setInner(inner);
            Mono<SnapshotInner> result = Mono.just(inner);
            if (inner.copyCompletionError() != null) {
                result = Mono.error(new ManagementException(inner.copyCompletionError().errorMessage(), null));
            }
            return result;
        }).takeUntil(inner -> {
            if (Float.valueOf(100.0f).equals(inner.completionPercent())) {
                return true;
            }
            this.logger.info("Wait for CopyStart complete for snapshot: {}. Complete percent: {}.", inner.name(), inner.completionPercent());
            return false;
        }).then();
    }

    @Override
    public SnapshotImpl withLinuxFromVhd(String vhdUrl) {
        return this.withLinuxFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withLinuxFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)this.innerModel()).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(String sourceDiskId) {
        ((SnapshotInner)this.innerModel()).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(Disk sourceDisk) {
        this.withLinuxFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)this.innerModel()).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(Snapshot sourceSnapshot) {
        this.withLinuxFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.skuType());
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromVhd(String vhdUrl) {
        return this.withWindowsFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withWindowsFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)this.innerModel()).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(String sourceDiskId) {
        ((SnapshotInner)this.innerModel()).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(Disk sourceDisk) {
        this.withWindowsFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)this.innerModel()).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(Snapshot sourceSnapshot) {
        this.withWindowsFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.skuType());
        return this;
    }

    @Override
    public SnapshotImpl withDataFromVhd(String vhdUrl) {
        return this.withDataFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withDataFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(String snapshotId) {
        ((SnapshotInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(snapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(Snapshot snapshot) {
        return this.withDataFromSnapshot(snapshot.id());
    }

    @Override
    public SnapshotImpl withCopyStart() {
        ((SnapshotInner)this.innerModel()).creationData().withCreateOption(DiskCreateOption.COPY_START);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromDisk(String managedDiskId) {
        ((SnapshotInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(managedDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromDisk(Disk managedDisk) {
        return this.withDataFromDisk(managedDisk.id()).withOSType(managedDisk.osType());
    }

    @Override
    public SnapshotImpl withSizeInGB(int sizeInGB) {
        ((SnapshotInner)this.innerModel()).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public SnapshotImpl withIncremental(boolean enabled) {
        ((SnapshotInner)this.innerModel()).withIncremental(enabled);
        return this;
    }

    @Override
    public SnapshotImpl withOSType(OperatingSystemTypes osType) {
        ((SnapshotInner)this.innerModel()).withOsType(osType);
        return this;
    }

    @Override
    public SnapshotImpl withSku(SnapshotSkuType sku) {
        ((SnapshotInner)this.innerModel()).withSku(new SnapshotSku().withName(sku.accountType()));
        return this;
    }

    @Override
    public Mono<Snapshot> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().createOrUpdateAsync(this.resourceGroupName(), this.name(), (SnapshotInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<SnapshotInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private String constructStorageAccountId(String vhdUrl) {
        try {
            return ResourceUtils.constructResourceId(((ComputeManager)this.manager()).subscriptionId(), this.resourceGroupName(), "Microsoft.Storage", "storageAccounts", vhdUrl.split("\\.")[0].replace("https://", ""), "");
        }
        catch (RuntimeException ex) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException(String.format("%s is not valid URI of a blob to import.", vhdUrl)));
        }
    }

    @Override
    public SnapshotImpl enablePublicNetworkAccess() {
        ((SnapshotInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        return this;
    }

    @Override
    public SnapshotImpl disablePublicNetworkAccess() {
        ((SnapshotInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        return this;
    }
}

