/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.SoftDeletedResourcesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.GallerySoftDeletedResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ApiErrorException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GallerySoftDeletedResourceList;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class SoftDeletedResourcesClientImpl
implements SoftDeletedResourcesClient {
    private final SoftDeletedResourcesService service;
    private final ComputeManagementClientImpl client;

    SoftDeletedResourcesClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(SoftDeletedResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>> listByArtifactNameSinglePageAsync(String resourceGroupName, String galleryName, String artifactType, String artifactName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (artifactType == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactType is required and cannot be null."));
        }
        if (artifactName == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByArtifactName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, artifactType, artifactName, "2024-03-03", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, GallerySoftDeletedResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GallerySoftDeletedResourceList)res.getValue()).value(), ((GallerySoftDeletedResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>> listByArtifactNameSinglePageAsync(String resourceGroupName, String galleryName, String artifactType, String artifactName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (artifactType == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactType is required and cannot be null."));
        }
        if (artifactName == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByArtifactName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, artifactType, artifactName, "2024-03-03", "application/json", context).map(res -> new PagedResponseBase<Object, GallerySoftDeletedResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GallerySoftDeletedResourceList)res.getValue()).value(), ((GallerySoftDeletedResourceList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GallerySoftDeletedResourceInner> listByArtifactNameAsync(String resourceGroupName, String galleryName, String artifactType, String artifactName) {
        return new PagedFlux<GallerySoftDeletedResourceInner>(() -> this.listByArtifactNameSinglePageAsync(resourceGroupName, galleryName, artifactType, artifactName), nextLink -> this.listByArtifactNameNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GallerySoftDeletedResourceInner> listByArtifactNameAsync(String resourceGroupName, String galleryName, String artifactType, String artifactName, Context context) {
        return new PagedFlux<GallerySoftDeletedResourceInner>(() -> this.listByArtifactNameSinglePageAsync(resourceGroupName, galleryName, artifactType, artifactName, context), nextLink -> this.listByArtifactNameNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GallerySoftDeletedResourceInner> listByArtifactName(String resourceGroupName, String galleryName, String artifactType, String artifactName) {
        return new PagedIterable<GallerySoftDeletedResourceInner>(this.listByArtifactNameAsync(resourceGroupName, galleryName, artifactType, artifactName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GallerySoftDeletedResourceInner> listByArtifactName(String resourceGroupName, String galleryName, String artifactType, String artifactName, Context context) {
        return new PagedIterable<GallerySoftDeletedResourceInner>(this.listByArtifactNameAsync(resourceGroupName, galleryName, artifactType, artifactName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>> listByArtifactNameNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByArtifactNameNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, GallerySoftDeletedResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GallerySoftDeletedResourceList)res.getValue()).value(), ((GallerySoftDeletedResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>> listByArtifactNameNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByArtifactNameNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, GallerySoftDeletedResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GallerySoftDeletedResourceList)res.getValue()).value(), ((GallerySoftDeletedResourceList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface SoftDeletedResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/softDeletedArtifactTypes/{artifactType}/artifacts/{artifactName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GallerySoftDeletedResourceList>> listByArtifactName(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="artifactType") String var5, @PathParam(value="artifactName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GallerySoftDeletedResourceList>> listByArtifactNameNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

