/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.EncryptionExtensionIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.EncryptionSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.LinuxDiskVolumeLegacyEncryptionMonitorImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.LinuxDiskVolumeNoAADEncryptionMonitorImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.WindowsVolumeLegacyEncryptionMonitorImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.WindowsVolumeNoAADEncryptionMonitorImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineEncryptionConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineExtension;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class VirtualMachineEncryptionHelper {
    private final OperatingSystemTypes osType;
    private final VirtualMachine virtualMachine;
    private static final String ERROR_ENCRYPTION_EXTENSION_NOT_FOUND = "Expected encryption extension not found in the VM";
    private static final String ERROR_NON_SUCCESS_PROVISIONING_STATE = "Extension needed for disk encryption was not provisioned correctly, found ProvisioningState as '%s'";
    private static final String ERROR_EXPECTED_KEY_VAULT_URL_NOT_FOUND = "Could not found URL pointing to the secret for disk encryption";
    private static final String ERROR_EXPECTED_ENCRYPTION_EXTENSION_STATUS_NOT_FOUND = "Encryption extension with successful status not found in the VM";
    private static final String ERROR_ENCRYPTION_EXTENSION_STATUS_IS_EMPTY = "Encryption extension status is empty";
    private static final String ERROR_ON_LINUX_ONLY_DATA_DISK_CAN_BE_DECRYPTED = "Only data disk is supported to disable encryption on Linux VM";
    private static final String ERROR_LEGACY_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_REQUIRED = "VM has Legacy Encryption Extension installed, updating it requires aadClientId and aadSecret parameters";
    private static final String ERROR_NOAAD_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_NOT_REQUIRED = "VM has NoAAD Encryption Extension installed, aadClientId and aadSecret parameters are not allowed for this extension.";
    private static final String ERROR_NO_DECRYPT_ENCRYPTION_EXTENSION_NOT_FOUND = "Expected encryption extension not found in the VM, no decryption to perform";

    VirtualMachineEncryptionHelper(VirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
        this.osType = this.virtualMachine.osType();
    }

    <T extends VirtualMachineEncryptionConfiguration<T>> Mono<DiskVolumeEncryptionMonitor> enableEncryptionAsync(VirtualMachineEncryptionConfiguration<T> encryptionConfig) {
        EncryptionSettings.Enable encryptSettings = EncryptionSettings.createEnable(encryptionConfig);
        return this.validateBeforeEncryptAsync(encryptSettings).flatMap(virtualMachineExtension -> this.updateEncryptionExtensionAsync(encryptSettings, (VirtualMachineExtension)virtualMachineExtension)).switchIfEmpty(this.installEncryptionExtensionAsync(encryptSettings)).flatMap(virtualMachine -> {
            if (encryptSettings.requestedForNoAADEncryptExtension()) {
                return this.noAADExtensionEncryptPostProcessingAsync((VirtualMachine)virtualMachine);
            }
            return this.legacyExtensionEncryptPostProcessingAsync(encryptSettings);
        });
    }

    Mono<DiskVolumeEncryptionMonitor> disableEncryptionAsync(DiskVolumeType volumeType) {
        EncryptionSettings.Disable encryptSettings = EncryptionSettings.createDisable(volumeType);
        return this.validateBeforeDecryptAsync(volumeType).flatMap(virtualMachineExtension -> this.updateEncryptionExtensionAsync(encryptSettings, (VirtualMachineExtension)virtualMachineExtension).map(virtualMachine -> new VMExtTuple((VirtualMachine)virtualMachine, (VirtualMachineExtension)virtualMachineExtension))).flatMap(vmExt -> {
            if (EncryptionExtensionIdentifier.isNoAADVersion(this.osType, ((VMExtTuple)vmExt).encryptExtension.versionName())) {
                return this.noAADExtensionDecryptPostProcessingAsync(((VMExtTuple)vmExt).virtualMachine);
            }
            return this.legacyExtensionDecryptPostProcessingAsync(encryptSettings);
        });
    }

    private Mono<DiskVolumeEncryptionMonitor> noAADExtensionEncryptPostProcessingAsync(VirtualMachine virtualMachine) {
        return this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync() : new WindowsVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync();
    }

    private <T extends VirtualMachineEncryptionConfiguration<T>> Mono<DiskVolumeEncryptionMonitor> legacyExtensionEncryptPostProcessingAsync(EncryptionSettings.Enable<T> encryptConfig) {
        return this.retrieveEncryptionExtensionStatusStringAsync(ERROR_EXPECTED_KEY_VAULT_URL_NOT_FOUND).flatMap(keyVaultSecretUrl -> this.updateVMStorageProfileAsync(encryptConfig, (String)keyVaultSecretUrl)).flatMap(virtualMachine -> this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync() : new WindowsVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync());
    }

    private Mono<DiskVolumeEncryptionMonitor> noAADExtensionDecryptPostProcessingAsync(VirtualMachine virtualMachine) {
        return this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync() : new WindowsVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync();
    }

    private Mono<DiskVolumeEncryptionMonitor> legacyExtensionDecryptPostProcessingAsync(EncryptionSettings.Disable encryptConfig) {
        return this.retrieveEncryptionExtensionStatusStringAsync(ERROR_ENCRYPTION_EXTENSION_STATUS_IS_EMPTY).flatMap(s2 -> this.updateVMStorageProfileAsync(encryptConfig)).flatMap(virtualMachine -> this.osType == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync() : new WindowsVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)virtualMachine.manager()).refreshAsync());
    }

    private <T extends VirtualMachineEncryptionConfiguration<T>> Mono<VirtualMachineExtension> validateBeforeEncryptAsync(EncryptionSettings.Enable<T> encryptSettings) {
        if (this.virtualMachine.storageProfile().osDisk().encryptionSettings() != null && encryptSettings.requestedForNoAADEncryptExtension()) {
            return Mono.error(new RuntimeException(ERROR_LEGACY_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_REQUIRED));
        }
        return this.getEncryptionExtensionInstalledInVMAsync().flatMap(extension -> {
            if (EncryptionExtensionIdentifier.isNoAADVersion(this.osType, extension.versionName())) {
                return encryptSettings.requestedForNoAADEncryptExtension() ? Mono.just(extension) : Mono.error(new RuntimeException(ERROR_NOAAD_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_NOT_REQUIRED));
            }
            return encryptSettings.requestedForNoAADEncryptExtension() ? Mono.error(new RuntimeException(ERROR_LEGACY_ENCRYPTION_EXTENSION_FOUND_AAD_PARAMS_REQUIRED)) : Mono.just(extension);
        });
    }

    private Mono<VirtualMachineExtension> validateBeforeDecryptAsync(DiskVolumeType volumeType) {
        if (this.osType == OperatingSystemTypes.LINUX && volumeType != DiskVolumeType.DATA) {
            return this.toErrorMono(ERROR_ON_LINUX_ONLY_DATA_DISK_CAN_BE_DECRYPTED);
        }
        return this.getEncryptionExtensionInstalledInVMAsync().switchIfEmpty(this.toErrorMono(ERROR_NO_DECRYPT_ENCRYPTION_EXTENSION_NOT_FOUND));
    }

    private Mono<VirtualMachineExtension> getEncryptionExtensionInstalledInVMAsync() {
        return this.virtualMachine.listExtensionsAsync().flatMapMany(Flux::fromIterable).filter(extension -> EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisherName()) && EncryptionExtensionIdentifier.isEncryptionTypeName(extension.typeName(), this.osType)).singleOrEmpty();
    }

    private Mono<VirtualMachine> updateEncryptionExtensionAsync(EncryptionSettings encryptSettings, VirtualMachineExtension encryptionExtension) {
        return ((VirtualMachine.Update)((VirtualMachine.Update)this.virtualMachine.update()).updateExtension(encryptionExtension.name()).withPublicSettings(encryptSettings.extensionPublicSettings()).withProtectedSettings(encryptSettings.extensionProtectedSettings()).parent()).applyAsync();
    }

    private <T extends VirtualMachineEncryptionConfiguration<T>> Mono<VirtualMachine> installEncryptionExtensionAsync(EncryptionSettings.Enable<T> encryptSettings) {
        return Mono.defer(() -> {
            String typeName = EncryptionExtensionIdentifier.typeName(this.osType);
            return ((VirtualMachine.Update)((VirtualMachine.Update)this.virtualMachine.update()).defineNewExtension(typeName).withPublisher(EncryptionExtensionIdentifier.publisherName()).withType(typeName).withVersion(encryptSettings.encryptionExtensionVersion()).withPublicSettings(encryptSettings.extensionPublicSettings()).withProtectedSettings(encryptSettings.extensionProtectedSettings()).withMinorVersionAutoUpgrade().attach()).applyAsync();
        });
    }

    private Mono<String> retrieveEncryptionExtensionStatusStringAsync(String statusEmptyErrorMessage) {
        VirtualMachineEncryptionHelper self = this;
        return this.getEncryptionExtensionInstalledInVMAsync().switchIfEmpty(self.toErrorMono(ERROR_ENCRYPTION_EXTENSION_NOT_FOUND)).flatMap(extension -> {
            if (!extension.provisioningState().equalsIgnoreCase("Succeeded")) {
                return self.toErrorMono(String.format(ERROR_NON_SUCCESS_PROVISIONING_STATE, extension.provisioningState()));
            }
            return extension.getInstanceViewAsync();
        }).flatMap(instanceView -> {
            String extensionStatus = instanceView.statuses().get(0).message();
            if (extensionStatus == null) {
                return self.toErrorMono(statusEmptyErrorMessage);
            }
            return Mono.just(extensionStatus);
        }).switchIfEmpty(self.toErrorMono(ERROR_EXPECTED_ENCRYPTION_EXTENSION_STATUS_NOT_FOUND));
    }

    private Mono<VirtualMachine> updateVMStorageProfileAsync(EncryptionSettings encryptSettings, String encryptionSecretKeyVaultUrl) {
        DiskEncryptionSettings diskEncryptionSettings = encryptSettings.storageProfileEncryptionSettings();
        diskEncryptionSettings.diskEncryptionKey().withSecretUrl(encryptionSecretKeyVaultUrl);
        return ((VirtualMachine.Update)this.virtualMachine.update()).withOSDiskEncryptionSettings(diskEncryptionSettings).applyAsync();
    }

    private Mono<VirtualMachine> updateVMStorageProfileAsync(EncryptionSettings encryptSettings) {
        DiskEncryptionSettings diskEncryptionSettings = encryptSettings.storageProfileEncryptionSettings();
        return ((VirtualMachine.Update)this.virtualMachine.update()).withOSDiskEncryptionSettings(diskEncryptionSettings).applyAsync();
    }

    private <ResultT> Mono<ResultT> toErrorMono(String message) {
        return Mono.error(new Exception(message));
    }

    private static class VMExtTuple {
        private final VirtualMachine virtualMachine;
        private final VirtualMachineExtension encryptExtension;

        VMExtTuple(VirtualMachine vm, VirtualMachineExtension ext) {
            this.virtualMachine = vm;
            this.encryptExtension = ext;
        }
    }
}

