/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.EncryptionExtensionIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class WindowsVolumeLegacyEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineExtensionInner encryptionExtension;
    private VirtualMachineInner virtualMachine;

    WindowsVolumeLegacyEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId(virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId(virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.WINDOWS;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionDetails()) {
            return null;
        }
        return String.format("OSDisk: %s DataDisk: %s", this.osDiskStatus(), this.dataDiskStatus());
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionDetails()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (this.encryptionExtension.provisioningState() == null) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (!this.encryptionExtension.provisioningState().equalsIgnoreCase("Succeeded")) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (this.virtualMachine.storageProfile() == null || this.virtualMachine.storageProfile().osDisk() == null || this.virtualMachine.storageProfile().osDisk().encryptionSettings() == null) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        DiskEncryptionSettings encryptionSettings = this.virtualMachine.storageProfile().osDisk().encryptionSettings();
        if (encryptionSettings.diskEncryptionKey() != null && encryptionSettings.diskEncryptionKey().secretUrl() != null && ResourceManagerUtils.toPrimitiveBoolean(encryptionSettings.enabled())) {
            return EncryptionStatus.ENCRYPTED;
        }
        return EncryptionStatus.NOT_ENCRYPTED;
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionDetails()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (this.encryptionExtension.provisioningState() == null) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (!this.encryptionExtension.provisioningState().equalsIgnoreCase("Succeeded")) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        LinkedHashMap publicSettings = new LinkedHashMap();
        if (this.encryptionExtension.settings() != null) {
            publicSettings = (LinkedHashMap)this.encryptionExtension.settings();
        }
        if (!publicSettings.containsKey("VolumeType") || ((HashMap)publicSettings).get("VolumeType") == null || ((String)((HashMap)publicSettings).get("VolumeType")).isEmpty() || ((String)((HashMap)publicSettings).get("VolumeType")).equalsIgnoreCase("All") || ((String)((HashMap)publicSettings).get("VolumeType")).equalsIgnoreCase("Data")) {
            String encryptionOperation = (String)((HashMap)publicSettings).get("EncryptionOperation");
            if (encryptionOperation != null && "EnableEncryption".equalsIgnoreCase(encryptionOperation)) {
                return EncryptionStatus.ENCRYPTED;
            }
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return EncryptionStatus.UNKNOWN;
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        return new HashMap<String, InstanceViewStatus>();
    }

    @Override
    public DiskVolumeEncryptionMonitor refresh() {
        return this.refreshAsync().block();
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> refreshAsync() {
        WindowsVolumeLegacyEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().map(virtualMachine -> {
            self.virtualMachine = virtualMachine;
            if (virtualMachine.resources() != null) {
                for (VirtualMachineExtensionInner extension : virtualMachine.resources()) {
                    if (!EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisher()) || !EncryptionExtensionIdentifier.isEncryptionTypeName(extension.typePropertiesType(), OperatingSystemTypes.WINDOWS)) continue;
                    self.encryptionExtension = extension;
                    break;
                }
            }
            return self;
        });
    }

    private Mono<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachines().getByResourceGroupAsync(this.rgName, this.vmName);
    }

    private boolean hasEncryptionDetails() {
        return this.virtualMachine != null && this.encryptionExtension != null;
    }
}

