/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostAvailableCapacity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import java.io.IOException;
import java.util.List;

public final class DedicatedHostInstanceViewWithName
extends DedicatedHostInstanceView {
    private String name;
    private String assetId;

    public String name() {
        return this.name;
    }

    @Override
    public String assetId() {
        return this.assetId;
    }

    @Override
    public DedicatedHostInstanceViewWithName withAvailableCapacity(DedicatedHostAvailableCapacity availableCapacity) {
        super.withAvailableCapacity(availableCapacity);
        return this;
    }

    @Override
    public DedicatedHostInstanceViewWithName withStatuses(List<InstanceViewStatus> statuses) {
        super.withStatuses(statuses);
        return this;
    }

    @Override
    public void validate() {
        if (this.availableCapacity() != null) {
            this.availableCapacity().validate();
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("availableCapacity", this.availableCapacity());
        jsonWriter.writeArrayField("statuses", this.statuses(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHostInstanceViewWithName fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostInstanceViewWithName deserializedDedicatedHostInstanceViewWithName = new DedicatedHostInstanceViewWithName();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assetId".equals(fieldName)) {
                    deserializedDedicatedHostInstanceViewWithName.assetId = reader.getString();
                    continue;
                }
                if ("availableCapacity".equals(fieldName)) {
                    deserializedDedicatedHostInstanceViewWithName.withAvailableCapacity(DedicatedHostAvailableCapacity.fromJson(reader));
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedDedicatedHostInstanceViewWithName.withStatuses((List)statuses);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDedicatedHostInstanceViewWithName.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHostInstanceViewWithName;
        });
    }
}

