/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.KeyVaultKeyReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.KeyVaultSecretReference;
import java.io.IOException;

public final class DiskEncryptionSettings
implements JsonSerializable<DiskEncryptionSettings> {
    private KeyVaultSecretReference diskEncryptionKey;
    private KeyVaultKeyReference keyEncryptionKey;
    private Boolean enabled;

    public KeyVaultSecretReference diskEncryptionKey() {
        return this.diskEncryptionKey;
    }

    public DiskEncryptionSettings withDiskEncryptionKey(KeyVaultSecretReference diskEncryptionKey) {
        this.diskEncryptionKey = diskEncryptionKey;
        return this;
    }

    public KeyVaultKeyReference keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public DiskEncryptionSettings withKeyEncryptionKey(KeyVaultKeyReference keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public DiskEncryptionSettings withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void validate() {
        if (this.diskEncryptionKey() != null) {
            this.diskEncryptionKey().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("diskEncryptionKey", this.diskEncryptionKey);
        jsonWriter.writeJsonField("keyEncryptionKey", this.keyEncryptionKey);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    public static DiskEncryptionSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskEncryptionSettings deserializedDiskEncryptionSettings = new DiskEncryptionSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskEncryptionKey".equals(fieldName)) {
                    deserializedDiskEncryptionSettings.diskEncryptionKey = KeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedDiskEncryptionSettings.keyEncryptionKey = KeyVaultKeyReference.fromJson(reader);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedDiskEncryptionSettings.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskEncryptionSettings;
        });
    }
}

