/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CachingTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiffDiskSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ManagedDiskParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualHardDisk;
import java.io.IOException;

public final class OSDisk
implements JsonSerializable<OSDisk> {
    private OperatingSystemTypes osType;
    private DiskEncryptionSettings encryptionSettings;
    private String name;
    private VirtualHardDisk vhd;
    private VirtualHardDisk image;
    private CachingTypes caching;
    private Boolean writeAcceleratorEnabled;
    private DiffDiskSettings diffDiskSettings;
    private DiskCreateOptionTypes createOption;
    private Integer diskSizeGB;
    private ManagedDiskParameters managedDisk;
    private DiskDeleteOptionTypes deleteOption;
    private static final ClientLogger LOGGER = new ClientLogger(OSDisk.class);

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public OSDisk withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public DiskEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public OSDisk withEncryptionSettings(DiskEncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public String name() {
        return this.name;
    }

    public OSDisk withName(String name) {
        this.name = name;
        return this;
    }

    public VirtualHardDisk vhd() {
        return this.vhd;
    }

    public OSDisk withVhd(VirtualHardDisk vhd) {
        this.vhd = vhd;
        return this;
    }

    public VirtualHardDisk image() {
        return this.image;
    }

    public OSDisk withImage(VirtualHardDisk image) {
        this.image = image;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public OSDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public OSDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiffDiskSettings diffDiskSettings() {
        return this.diffDiskSettings;
    }

    public OSDisk withDiffDiskSettings(DiffDiskSettings diffDiskSettings) {
        this.diffDiskSettings = diffDiskSettings;
        return this;
    }

    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    public OSDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public OSDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public OSDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public OSDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().validate();
        }
        if (this.vhd() != null) {
            this.vhd().validate();
        }
        if (this.image() != null) {
            this.image().validate();
        }
        if (this.diffDiskSettings() != null) {
            this.diffDiskSettings().validate();
        }
        if (this.createOption() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property createOption in model OSDisk"));
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeJsonField("encryptionSettings", this.encryptionSettings);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("vhd", this.vhd);
        jsonWriter.writeJsonField("image", this.image);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        jsonWriter.writeJsonField("diffDiskSettings", this.diffDiskSettings);
        jsonWriter.writeNumberField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeJsonField("managedDisk", this.managedDisk);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static OSDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OSDisk deserializedOSDisk = new OSDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createOption".equals(fieldName)) {
                    deserializedOSDisk.createOption = DiskCreateOptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedOSDisk.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    deserializedOSDisk.encryptionSettings = DiskEncryptionSettings.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOSDisk.name = reader.getString();
                    continue;
                }
                if ("vhd".equals(fieldName)) {
                    deserializedOSDisk.vhd = VirtualHardDisk.fromJson(reader);
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedOSDisk.image = VirtualHardDisk.fromJson(reader);
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedOSDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedOSDisk.writeAcceleratorEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("diffDiskSettings".equals(fieldName)) {
                    deserializedOSDisk.diffDiskSettings = DiffDiskSettings.fromJson(reader);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedOSDisk.diskSizeGB = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedOSDisk.managedDisk = ManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedOSDisk.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSDisk;
        });
    }
}

