/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OrchestrationServiceNames;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OrchestrationServiceStateAction;
import java.io.IOException;

public final class OrchestrationServiceStateInput
implements JsonSerializable<OrchestrationServiceStateInput> {
    private OrchestrationServiceNames serviceName;
    private OrchestrationServiceStateAction action;
    private static final ClientLogger LOGGER = new ClientLogger(OrchestrationServiceStateInput.class);

    public OrchestrationServiceNames serviceName() {
        return this.serviceName;
    }

    public OrchestrationServiceStateInput withServiceName(OrchestrationServiceNames serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public OrchestrationServiceStateAction action() {
        return this.action;
    }

    public OrchestrationServiceStateInput withAction(OrchestrationServiceStateAction action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.serviceName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property serviceName in model OrchestrationServiceStateInput"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property action in model OrchestrationServiceStateInput"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName == null ? null : this.serviceName.toString());
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    public static OrchestrationServiceStateInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrchestrationServiceStateInput deserializedOrchestrationServiceStateInput = new OrchestrationServiceStateInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceName".equals(fieldName)) {
                    deserializedOrchestrationServiceStateInput.serviceName = OrchestrationServiceNames.fromString(reader.getString());
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedOrchestrationServiceStateInput.action = OrchestrationServiceStateAction.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrchestrationServiceStateInput;
        });
    }
}

