/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ZonePlacementPolicyType;
import java.io.IOException;
import java.util.List;

public final class Placement
implements JsonSerializable<Placement> {
    private ZonePlacementPolicyType zonePlacementPolicy;
    private List<String> includeZones;
    private List<String> excludeZones;

    public ZonePlacementPolicyType zonePlacementPolicy() {
        return this.zonePlacementPolicy;
    }

    public Placement withZonePlacementPolicy(ZonePlacementPolicyType zonePlacementPolicy) {
        this.zonePlacementPolicy = zonePlacementPolicy;
        return this;
    }

    public List<String> includeZones() {
        return this.includeZones;
    }

    public Placement withIncludeZones(List<String> includeZones) {
        this.includeZones = includeZones;
        return this;
    }

    public List<String> excludeZones() {
        return this.excludeZones;
    }

    public Placement withExcludeZones(List<String> excludeZones) {
        this.excludeZones = excludeZones;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("zonePlacementPolicy", this.zonePlacementPolicy == null ? null : this.zonePlacementPolicy.toString());
        jsonWriter.writeArrayField("includeZones", this.includeZones, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("excludeZones", this.excludeZones, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static Placement fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Placement deserializedPlacement = new Placement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("zonePlacementPolicy".equals(fieldName)) {
                    deserializedPlacement.zonePlacementPolicy = ZonePlacementPolicyType.fromString(reader.getString());
                    continue;
                }
                if ("includeZones".equals(fieldName)) {
                    List<String> includeZones = reader.readArray(reader1 -> reader1.getString());
                    deserializedPlacement.includeZones = includeZones;
                    continue;
                }
                if ("excludeZones".equals(fieldName)) {
                    List<String> excludeZones = reader.readArray(reader1 -> reader1.getString());
                    deserializedPlacement.excludeZones = excludeZones;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlacement;
        });
    }
}

