/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.NetworkApiVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineScaleSetNetworkConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetNetworkProfile
implements JsonSerializable<VirtualMachineScaleSetNetworkProfile> {
    private ApiEntityReference healthProbe;
    private List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations;
    private NetworkApiVersion networkApiVersion;

    public ApiEntityReference healthProbe() {
        return this.healthProbe;
    }

    public VirtualMachineScaleSetNetworkProfile withHealthProbe(ApiEntityReference healthProbe) {
        this.healthProbe = healthProbe;
        return this;
    }

    public List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations() {
        return this.networkInterfaceConfigurations;
    }

    public VirtualMachineScaleSetNetworkProfile withNetworkInterfaceConfigurations(List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations) {
        this.networkInterfaceConfigurations = networkInterfaceConfigurations;
        return this;
    }

    public NetworkApiVersion networkApiVersion() {
        return this.networkApiVersion;
    }

    public VirtualMachineScaleSetNetworkProfile withNetworkApiVersion(NetworkApiVersion networkApiVersion) {
        this.networkApiVersion = networkApiVersion;
        return this;
    }

    public void validate() {
        if (this.healthProbe() != null) {
            this.healthProbe().validate();
        }
        if (this.networkInterfaceConfigurations() != null) {
            this.networkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("healthProbe", this.healthProbe);
        jsonWriter.writeArrayField("networkInterfaceConfigurations", this.networkInterfaceConfigurations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("networkApiVersion", this.networkApiVersion == null ? null : this.networkApiVersion.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetNetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetNetworkProfile deserializedVirtualMachineScaleSetNetworkProfile = new VirtualMachineScaleSetNetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("healthProbe".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkProfile.healthProbe = ApiEntityReference.fromJson(reader);
                    continue;
                }
                if ("networkInterfaceConfigurations".equals(fieldName)) {
                    List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations = reader.readArray(reader1 -> VirtualMachineScaleSetNetworkConfiguration.fromJson(reader1));
                    deserializedVirtualMachineScaleSetNetworkProfile.networkInterfaceConfigurations = networkInterfaceConfigurations;
                    continue;
                }
                if ("networkApiVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkProfile.networkApiVersion = NetworkApiVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetNetworkProfile;
        });
    }
}

