/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.TaskProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Credentials;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TriggerProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class TaskInner
extends Resource {
    private IdentityProperties identity;
    private TaskProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private TaskProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public TaskInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public TaskInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public TaskStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public TaskInner withStatus(TaskStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public PlatformProperties platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    public TaskInner withPlatform(PlatformProperties platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().agentConfiguration();
    }

    public TaskInner withAgentConfiguration(AgentProperties agentConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withAgentConfiguration(agentConfiguration);
        return this;
    }

    public String agentPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolName();
    }

    public TaskInner withAgentPoolName(String agentPoolName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withAgentPoolName(agentPoolName);
        return this;
    }

    public Integer timeout() {
        return this.innerProperties() == null ? null : this.innerProperties().timeout();
    }

    public TaskInner withTimeout(Integer timeout2) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withTimeout(timeout2);
        return this;
    }

    public TaskStepProperties step() {
        return this.innerProperties() == null ? null : this.innerProperties().step();
    }

    public TaskInner withStep(TaskStepProperties step) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withStep(step);
        return this;
    }

    public TriggerProperties trigger() {
        return this.innerProperties() == null ? null : this.innerProperties().trigger();
    }

    public TaskInner withTrigger(TriggerProperties trigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withTrigger(trigger);
        return this;
    }

    public Credentials credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    public TaskInner withCredentials(Credentials credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    public String logTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().logTemplate();
    }

    public TaskInner withLogTemplate(String logTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withLogTemplate(logTemplate);
        return this;
    }

    public Boolean isSystemTask() {
        return this.innerProperties() == null ? null : this.innerProperties().isSystemTask();
    }

    public TaskInner withIsSystemTask(Boolean isSystemTask) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withIsSystemTask(isSystemTask);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TaskInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskInner deserializedTaskInner = new TaskInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTaskInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTaskInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTaskInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTaskInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTaskInner.withTags((Map)tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedTaskInner.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTaskInner.innerProperties = TaskProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTaskInner.systemData = SystemData.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskInner;
        });
    }
}

