/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.RegistriesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.RegistryListCredentialsResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.RegistryNameStatusInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.RegistryUsageListResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.SourceUploadDefinitionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.CheckNameAvailabilityResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistriesWebhooksClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryCredentialsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.SourceUploadDefinitionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.CheckNameAvailabilityResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.PasswordName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegenerateCredentialParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Registries;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Registry;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryCredentials;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryNameCheckRequest;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryUsage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SourceUploadDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class RegistriesImpl
extends GroupableResourcesImpl<Registry, RegistryImpl, RegistryInner, RegistriesClient, ContainerRegistryManager>
implements Registries {
    public RegistriesImpl(ContainerRegistryManager manager) {
        super(((ContainerRegistryManagementClient)manager.serviceClient()).getRegistries(), manager);
    }

    @Override
    public PagedIterable<Registry> list() {
        return new PagedIterable<Registry>(this.listAsync());
    }

    @Override
    public PagedFlux<Registry> listAsync() {
        return PagedConverter.mapPage(((RegistriesClient)this.inner()).listAsync(), inner -> new RegistryImpl(inner.name(), (RegistryInner)inner, (ContainerRegistryManager)this.manager()));
    }

    @Override
    public PagedFlux<Registry> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<Registry>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((RegistriesClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<Registry> listByResourceGroup(String groupName) {
        return new PagedIterable<Registry>(this.listByResourceGroupAsync(groupName));
    }

    @Override
    protected Mono<RegistryInner> getInnerAsync(String resourceGroupName, String name) {
        return ((RegistriesClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    public RegistryImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String groupName, String name) {
        return ((RegistriesClient)this.inner()).deleteAsync(groupName, name);
    }

    @Override
    protected RegistryImpl wrapModel(String name) {
        return new RegistryImpl(name, new RegistryInner(), (ContainerRegistryManager)this.manager());
    }

    @Override
    protected RegistryImpl wrapModel(RegistryInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new RegistryImpl(containerServiceInner.name(), containerServiceInner, (ContainerRegistryManager)this.manager());
    }

    @Override
    public RegistryCredentials getCredentials(String resourceGroupName, String registryName) {
        return new RegistryCredentialsImpl(((RegistriesClient)this.inner()).listCredentials(resourceGroupName, registryName));
    }

    @Override
    public Mono<RegistryCredentials> getCredentialsAsync(String resourceGroupName, String registryName) {
        return ((RegistriesClient)this.inner()).listCredentialsAsync(resourceGroupName, registryName).map(registryListCredentialsResultInner -> new RegistryCredentialsImpl((RegistryListCredentialsResultInner)registryListCredentialsResultInner));
    }

    @Override
    public RegistryCredentials regenerateCredential(String resourceGroupName, String registryName, AccessKeyType accessKeyType) {
        return new RegistryCredentialsImpl(((RegistriesClient)this.inner()).regenerateCredential(resourceGroupName, registryName, new RegenerateCredentialParameters().withName(PasswordName.fromString(accessKeyType.toString()))));
    }

    @Override
    public Mono<RegistryCredentials> regenerateCredentialAsync(String resourceGroupName, String registryName, AccessKeyType accessKeyType) {
        return ((RegistriesClient)this.inner()).regenerateCredentialAsync(resourceGroupName, registryName, new RegenerateCredentialParameters().withName(PasswordName.fromString(accessKeyType.toString()))).map(RegistryCredentialsImpl::new);
    }

    @Override
    public Collection<RegistryUsage> listQuotaUsages(String resourceGroupName, String registryName) {
        RegistryUsageListResultInner resultInner = ((RegistriesClient)this.inner()).listUsages(resourceGroupName, registryName);
        return Collections.unmodifiableList(resultInner != null && resultInner.value() != null ? resultInner.value() : new ArrayList());
    }

    @Override
    public PagedFlux<RegistryUsage> listQuotaUsagesAsync(String resourceGroupName, String registryName) {
        return PagedConverter.convertListToPagedFlux(((RegistriesClient)this.inner()).listUsagesWithResponseAsync(resourceGroupName, registryName).map(r -> new SimpleResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), ((RegistryUsageListResultInner)r.getValue()).value() == null ? Collections.emptyList() : ((RegistryUsageListResultInner)r.getValue()).value())));
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((RegistriesClient)this.inner()).checkNameAvailability(new RegistryNameCheckRequest().withName(name)));
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((RegistriesClient)this.inner()).checkNameAvailabilityAsync(new RegistryNameCheckRequest().withName(name)).map(registryNameStatusInner -> new CheckNameAvailabilityResultImpl((RegistryNameStatusInner)registryNameStatusInner));
    }

    @Override
    public SourceUploadDefinition getBuildSourceUploadUrl(String rgName, String acrName) {
        return this.getBuildSourceUploadUrlAsync(rgName, acrName).block();
    }

    @Override
    public Mono<SourceUploadDefinition> getBuildSourceUploadUrlAsync(String rgName, String acrName) {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().getBuildSourceUploadUrlAsync(rgName, acrName).map(sourceUploadDefinitionInner -> new SourceUploadDefinitionImpl((SourceUploadDefinitionInner)sourceUploadDefinitionInner));
    }

    @Override
    public Registries.WebhooksClient webhooks() {
        return new RegistriesWebhooksClientImpl((ContainerRegistryManager)this.manager(), null);
    }
}

