/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.PrivateLinkResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.SourceUploadDefinitionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryTaskRunImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.SourceUploadDefinitionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.WebhookImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.WebhookOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.WebhooksImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Action;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ActionsRequired;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ConnectionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.DefaultAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.IpRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.PrivateLinkServiceConnectionState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Registry;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryCredentials;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryUsage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SourceUploadDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.WebhookOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnectionProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointServiceConnectionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RegistryImpl
extends GroupableResourceImpl<Registry, RegistryInner, RegistryImpl, ContainerRegistryManager>
implements Registry,
Registry.Definition,
Registry.Update {
    private RegistryUpdateParameters updateParameters;
    private WebhooksImpl webhooks = new WebhooksImpl(this, "Webhook");

    protected RegistryImpl(String name, RegistryInner innerObject, ContainerRegistryManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    protected Mono<RegistryInner> getInnerAsync() {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public RegistryImpl update() {
        this.updateParameters = new RegistryUpdateParameters();
        return (RegistryImpl)super.update();
    }

    @Override
    public Mono<Registry> createResourceAsync() {
        RegistryImpl self = this;
        if (this.isInCreateMode()) {
            return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().createAsync(self.resourceGroupName(), self.name(), (RegistryInner)self.innerModel()).map(this.innerToFluentMap(this));
        }
        this.updateParameters.withTags(((RegistryInner)this.innerModel()).tags());
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().updateAsync(self.resourceGroupName(), self.name(), self.updateParameters).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.webhooks.clear();
        return Mono.empty();
    }

    @Override
    public Sku sku() {
        return ((RegistryInner)this.innerModel()).sku();
    }

    @Override
    public String loginServerUrl() {
        return ((RegistryInner)this.innerModel()).loginServer();
    }

    @Override
    public OffsetDateTime creationDate() {
        return ((RegistryInner)this.innerModel()).creationDate();
    }

    @Override
    public boolean adminUserEnabled() {
        return ((RegistryInner)this.innerModel()).adminUserEnabled();
    }

    @Override
    public RegistryImpl withBasicSku() {
        return this.setManagedSku(new Sku().withName(SkuName.BASIC));
    }

    @Override
    public RegistryImpl withStandardSku() {
        return this.setManagedSku(new Sku().withName(SkuName.STANDARD));
    }

    @Override
    public RegistryImpl withPremiumSku() {
        return this.setManagedSku(new Sku().withName(SkuName.PREMIUM));
    }

    private RegistryImpl setManagedSku(Sku sku) {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withSku(sku);
        } else {
            this.updateParameters.withSku(sku);
        }
        return this;
    }

    @Override
    public RegistryImpl withRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withAdminUserEnabled(true);
        } else {
            this.updateParameters.withAdminUserEnabled(true);
        }
        return this;
    }

    @Override
    public RegistryImpl withoutRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withAdminUserEnabled(false);
        } else {
            this.updateParameters.withAdminUserEnabled(false);
        }
        return this;
    }

    @Override
    public RegistryCredentials getCredentials() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().getCredentials(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<RegistryCredentials> getCredentialsAsync() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().getCredentialsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public RegistryCredentials regenerateCredential(AccessKeyType accessKeyType) {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().regenerateCredential(this.resourceGroupName(), this.name(), accessKeyType);
    }

    @Override
    public Mono<RegistryCredentials> regenerateCredentialAsync(AccessKeyType accessKeyType) {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().regenerateCredentialAsync(this.resourceGroupName(), this.name(), accessKeyType);
    }

    @Override
    public Collection<RegistryUsage> listQuotaUsages() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().listQuotaUsages(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedFlux<RegistryUsage> listQuotaUsagesAsync() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().listQuotaUsagesAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public WebhookOperations webhooks() {
        return new WebhookOperationsImpl(this);
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return ((RegistryInner)this.innerModel()).publicNetworkAccess();
    }

    @Override
    public boolean canAccessFromTrustedServices() {
        return ((RegistryInner)this.innerModel()).networkRuleBypassOptions() == NetworkRuleBypassOptions.AZURE_SERVICES;
    }

    @Override
    public NetworkRuleSet networkRuleSet() {
        return ((RegistryInner)this.innerModel()).networkRuleSet();
    }

    @Override
    public boolean isDedicatedDataEndpointsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((RegistryInner)this.innerModel()).dataEndpointEnabled());
    }

    @Override
    public boolean isZoneRedundancyEnabled() {
        return !Objects.isNull(((RegistryInner)this.innerModel()).zoneRedundancy()) && ZoneRedundancy.ENABLED.equals(((RegistryInner)this.innerModel()).zoneRedundancy());
    }

    @Override
    public List<String> dedicatedDataEndpointsHostNames() {
        return ((RegistryInner)this.innerModel()).dataEndpointHostNames() == null ? Collections.emptyList() : Collections.unmodifiableList(((RegistryInner)this.innerModel()).dataEndpointHostNames());
    }

    @Override
    public RegistryTaskRun.DefinitionStages.BlankFromRegistry scheduleRun() {
        return new RegistryTaskRunImpl((ContainerRegistryManager)this.manager(), new RunInner()).withExistingRegistry(this.resourceGroupName(), this.name());
    }

    @Override
    public SourceUploadDefinition getBuildSourceUploadUrl() {
        return this.getBuildSourceUploadUrlAsync().block();
    }

    @Override
    public Mono<SourceUploadDefinition> getBuildSourceUploadUrlAsync() {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().getBuildSourceUploadUrlAsync(this.resourceGroupName(), this.name()).map(sourceUploadDefinitionInner -> new SourceUploadDefinitionImpl((SourceUploadDefinitionInner)sourceUploadDefinitionInner));
    }

    @Override
    public RegistryImpl withoutWebhook(String name) {
        this.webhooks.withoutWebhook(name);
        return this;
    }

    public WebhookImpl updateWebhook(String name) {
        return this.webhooks.updateWebhook(name);
    }

    public WebhookImpl defineWebhook(String name) {
        return this.webhooks.defineWebhook(name);
    }

    @Override
    public RegistryImpl enablePublicNetworkAccess() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        } else {
            this.updateParameters.withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        }
        return this;
    }

    @Override
    public RegistryImpl disablePublicNetworkAccess() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        } else {
            this.updateParameters.withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        }
        return this;
    }

    @Override
    public RegistryImpl withAccessFromSelectedNetworks() {
        this.ensureNetworkRuleSet();
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).networkRuleSet().withDefaultAction(DefaultAction.DENY);
        } else {
            this.updateParameters.networkRuleSet().withDefaultAction(DefaultAction.DENY);
        }
        return this;
    }

    @Override
    public RegistryImpl withAccessFromAllNetworks() {
        this.ensureNetworkRuleSet();
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).networkRuleSet().withDefaultAction(DefaultAction.ALLOW);
        } else {
            this.updateParameters.networkRuleSet().withDefaultAction(DefaultAction.ALLOW);
        }
        return this;
    }

    @Override
    public RegistryImpl withAccessFromIpAddressRange(String ipAddressCidr) {
        this.ensureNetworkRuleSet();
        if (((RegistryInner)this.innerModel()).networkRuleSet().ipRules().stream().noneMatch(ipRule -> Objects.equals(ipRule.ipAddressOrRange(), ipAddressCidr))) {
            ((RegistryInner)this.innerModel()).networkRuleSet().ipRules().add(new IpRule().withAction(Action.ALLOW).withIpAddressOrRange(ipAddressCidr));
        }
        if (!this.isInCreateMode()) {
            this.updateParameters.networkRuleSet().withIpRules(((RegistryInner)this.innerModel()).networkRuleSet().ipRules());
        }
        return this;
    }

    @Override
    public RegistryImpl withoutAccessFromIpAddressRange(String ipAddressCidr) {
        if (((RegistryInner)this.innerModel()).networkRuleSet() == null) {
            return this;
        }
        this.ensureNetworkRuleSet();
        ((RegistryInner)this.innerModel()).networkRuleSet().ipRules().removeIf(ipRule -> Objects.equals(ipRule.ipAddressOrRange(), ipAddressCidr));
        if (!this.isInCreateMode()) {
            this.updateParameters.networkRuleSet().withIpRules(((RegistryInner)this.innerModel()).networkRuleSet().ipRules());
        }
        return this;
    }

    @Override
    public RegistryImpl withAccessFromIpAddress(String ipAddress) {
        return this.withAccessFromIpAddressRange(ipAddress);
    }

    @Override
    public RegistryImpl withoutAccessFromIpAddress(String ipAddress) {
        return this.withoutAccessFromIpAddressRange(ipAddress);
    }

    @Override
    public RegistryImpl withAccessFromTrustedServices() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withNetworkRuleBypassOptions(NetworkRuleBypassOptions.AZURE_SERVICES);
        } else {
            this.updateParameters.withNetworkRuleBypassOptions(NetworkRuleBypassOptions.AZURE_SERVICES);
        }
        return this;
    }

    @Override
    public RegistryImpl withoutAccessFromTrustedServices() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withNetworkRuleBypassOptions(NetworkRuleBypassOptions.NONE);
        } else {
            this.updateParameters.withNetworkRuleBypassOptions(NetworkRuleBypassOptions.NONE);
        }
        return this;
    }

    @Override
    public RegistryImpl enableDedicatedDataEndpoints() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withDataEndpointEnabled(true);
        } else {
            this.updateParameters.withDataEndpointEnabled(true);
        }
        return this;
    }

    @Override
    public RegistryImpl disableDedicatedDataEndpoints() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withDataEndpointEnabled(false);
        } else {
            this.updateParameters.withDataEndpointEnabled(false);
        }
        return this;
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listPrivateEndpointConnections() {
        return new PagedIterable<PrivateEndpointConnection>(this.listPrivateEndpointConnectionsAsync());
    }

    @Override
    public PagedFlux<PrivateEndpointConnection> listPrivateEndpointConnectionsAsync() {
        return PagedConverter.mapPage(((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getPrivateEndpointConnections().listAsync(this.resourceGroupName(), this.name()), x$0 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)x$0));
    }

    @Override
    public void approvePrivateEndpointConnection(String privateEndpointConnectionName) {
        this.approvePrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> approvePrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getPrivateEndpointConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(ConnectionStatus.APPROVED))).then();
    }

    @Override
    public void rejectPrivateEndpointConnection(String privateEndpointConnectionName) {
        this.rejectPrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> rejectPrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getPrivateEndpointConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(ConnectionStatus.REJECTED))).then();
    }

    private void ensureNetworkRuleSet() {
        if (this.isInCreateMode()) {
            if (((RegistryInner)this.innerModel()).networkRuleSet() == null) {
                ((RegistryInner)this.innerModel()).withNetworkRuleSet(new NetworkRuleSet());
                ((RegistryInner)this.innerModel()).networkRuleSet().withIpRules(new ArrayList<IpRule>());
            }
        } else if (this.updateParameters.networkRuleSet() == null) {
            this.updateParameters.withNetworkRuleSet(((RegistryInner)this.innerModel()).networkRuleSet());
        }
    }

    @Override
    public PagedIterable<PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable<PrivateLinkResource>(this.listPrivateLinkResourcesAsync());
    }

    @Override
    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().listPrivateLinkResourcesAsync(this.resourceGroupName(), this.name()).mapPage(x$0 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)x$0));
    }

    @Override
    public RegistryImpl withZoneRedundancy() {
        if (this.isInCreateMode()) {
            ((RegistryInner)this.innerModel()).withZoneRedundancy(ZoneRedundancy.ENABLED);
        }
        return this;
    }

    private static final class PrivateLinkResourceImpl
    implements PrivateLinkResource {
        private final PrivateLinkResourceInner innerModel;

        private PrivateLinkResourceImpl(PrivateLinkResourceInner innerModel) {
            this.innerModel = innerModel;
        }

        @Override
        public String groupId() {
            return this.innerModel.groupId();
        }

        @Override
        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.requiredMembers());
        }

        @Override
        public List<String> requiredDnsZoneNames() {
            return Collections.unmodifiableList(this.innerModel.requiredZoneNames());
        }
    }

    private static final class PrivateEndpointConnectionImpl
    implements PrivateEndpointConnection {
        private final PrivateEndpointConnectionInner innerModel;
        private final PrivateEndpoint privateEndpoint;
        private final com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
        private final PrivateEndpointConnectionProvisioningState provisioningState;

        private PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerModel) {
            this.innerModel = innerModel;
            PrivateEndpoint privateEndpoint = this.privateEndpoint = innerModel.privateEndpoint() == null ? null : new PrivateEndpoint(innerModel.privateEndpoint().id());
            this.privateLinkServiceConnectionState = innerModel.privateLinkServiceConnectionState() == null ? null : new com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkServiceConnectionState(innerModel.privateLinkServiceConnectionState().status() == null ? null : PrivateEndpointServiceConnectionStatus.fromString(innerModel.privateLinkServiceConnectionState().status().toString()), innerModel.privateLinkServiceConnectionState().description(), innerModel.privateLinkServiceConnectionState().actionsRequired() == null ? ActionsRequired.NONE.toString() : innerModel.privateLinkServiceConnectionState().actionsRequired().toString());
            this.provisioningState = innerModel.provisioningState() == null ? null : PrivateEndpointConnectionProvisioningState.fromString(innerModel.provisioningState().toString());
        }

        @Override
        public String id() {
            return this.innerModel.id();
        }

        @Override
        public String name() {
            return this.innerModel.name();
        }

        @Override
        public String type() {
            return this.innerModel.type();
        }

        @Override
        public PrivateEndpoint privateEndpoint() {
            return this.privateEndpoint;
        }

        @Override
        public com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
            return this.privateLinkServiceConnectionState;
        }

        @Override
        public PrivateEndpointConnectionProvisioningState provisioningState() {
            return this.provisioningState;
        }
    }
}

