/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryTaskRunImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTaskRuns;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class RegistryTaskRunsImpl
implements RegistryTaskRuns {
    private ContainerRegistryManager registryManager;

    public RegistryTaskRunsImpl(ContainerRegistryManager registryManager) {
        this.registryManager = registryManager;
    }

    @Override
    public RegistryTaskRun.DefinitionStages.BlankFromRuns scheduleRun() {
        return new RegistryTaskRunImpl(this.registryManager, new RunInner());
    }

    @Override
    public PagedFlux<RegistryTaskRun> listByRegistryAsync(String rgName, String acrName) {
        return PagedConverter.mapPage(((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getRuns().listAsync(rgName, acrName), inner -> this.wrapModel((RunInner)inner));
    }

    @Override
    public PagedIterable<RegistryTaskRun> listByRegistry(String rgName, String acrName) {
        return new PagedIterable<RegistryTaskRun>(this.listByRegistryAsync(rgName, acrName));
    }

    @Override
    public Mono<String> getLogSasUrlAsync(String rgName, String acrName, String runId) {
        return ((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getRuns().getLogSasUrlAsync(rgName, acrName, runId).map(runGetLogResultInner -> runGetLogResultInner.logLink());
    }

    @Override
    public String getLogSasUrl(String rgName, String acrName, String runId) {
        return this.getLogSasUrlAsync(rgName, acrName, runId).block();
    }

    @Override
    public Mono<Void> cancelAsync(String rgName, String acrName, String runId) {
        return ((ContainerRegistryManagementClient)this.registryManager.serviceClient()).getRuns().cancelAsync(rgName, acrName, runId);
    }

    @Override
    public void cancel(String rgName, String acrName, String runId) {
        this.cancelAsync(rgName, acrName, runId).block();
    }

    private RegistryTaskRunImpl wrapModel(RunInner innerModel) {
        return new RegistryTaskRunImpl(this.registryManager, innerModel);
    }
}

