/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;

public final class Argument
implements JsonSerializable<Argument> {
    private String name;
    private String value;
    private Boolean isSecret;
    private static final ClientLogger LOGGER = new ClientLogger(Argument.class);

    public String name() {
        return this.name;
    }

    public Argument withName(String name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public Argument withValue(String value) {
        this.value = value;
        return this;
    }

    public Boolean isSecret() {
        return this.isSecret;
    }

    public Argument withIsSecret(Boolean isSecret) {
        this.isSecret = isSecret;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Argument"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property value in model Argument"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeBooleanField("isSecret", this.isSecret);
        return jsonWriter.writeEndObject();
    }

    public static Argument fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Argument deserializedArgument = new Argument();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedArgument.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedArgument.value = reader.getString();
                    continue;
                }
                if ("isSecret".equals(fieldName)) {
                    deserializedArgument.isSecret = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArgument;
        });
    }
}

