/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TokenType;
import java.io.IOException;

public final class AuthInfo
implements JsonSerializable<AuthInfo> {
    private TokenType tokenType;
    private String token;
    private String refreshToken;
    private String scope;
    private Integer expiresIn;
    private static final ClientLogger LOGGER = new ClientLogger(AuthInfo.class);

    public TokenType tokenType() {
        return this.tokenType;
    }

    public AuthInfo withTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public String token() {
        return this.token;
    }

    public AuthInfo withToken(String token) {
        this.token = token;
        return this;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public AuthInfo withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public AuthInfo withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public Integer expiresIn() {
        return this.expiresIn;
    }

    public AuthInfo withExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    public void validate() {
        if (this.tokenType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property tokenType in model AuthInfo"));
        }
        if (this.token() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property token in model AuthInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tokenType", this.tokenType == null ? null : this.tokenType.toString());
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeStringField("refreshToken", this.refreshToken);
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeNumberField("expiresIn", this.expiresIn);
        return jsonWriter.writeEndObject();
    }

    public static AuthInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthInfo deserializedAuthInfo = new AuthInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokenType".equals(fieldName)) {
                    deserializedAuthInfo.tokenType = TokenType.fromString(reader.getString());
                    continue;
                }
                if ("token".equals(fieldName)) {
                    deserializedAuthInfo.token = reader.getString();
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedAuthInfo.refreshToken = reader.getString();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedAuthInfo.scope = reader.getString();
                    continue;
                }
                if ("expiresIn".equals(fieldName)) {
                    deserializedAuthInfo.expiresIn = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthInfo;
        });
    }
}

