/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Credentials;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SetValue;
import java.io.IOException;
import java.util.List;

public final class EncodedTaskRunRequest
extends RunRequest {
    private String type = "EncodedTaskRunRequest";
    private String encodedTaskContent;
    private String encodedValuesContent;
    private List<SetValue> values;
    private Integer timeout;
    private PlatformProperties platform;
    private AgentProperties agentConfiguration;
    private String sourceLocation;
    private Credentials credentials;
    private static final ClientLogger LOGGER = new ClientLogger(EncodedTaskRunRequest.class);

    @Override
    public String type() {
        return this.type;
    }

    public String encodedTaskContent() {
        return this.encodedTaskContent;
    }

    public EncodedTaskRunRequest withEncodedTaskContent(String encodedTaskContent) {
        this.encodedTaskContent = encodedTaskContent;
        return this;
    }

    public String encodedValuesContent() {
        return this.encodedValuesContent;
    }

    public EncodedTaskRunRequest withEncodedValuesContent(String encodedValuesContent) {
        this.encodedValuesContent = encodedValuesContent;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public EncodedTaskRunRequest withValues(List<SetValue> values2) {
        this.values = values2;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public EncodedTaskRunRequest withTimeout(Integer timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public EncodedTaskRunRequest withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public EncodedTaskRunRequest withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public EncodedTaskRunRequest withSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public EncodedTaskRunRequest withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public EncodedTaskRunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    @Override
    public EncodedTaskRunRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    @Override
    public EncodedTaskRunRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.encodedTaskContent() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property encodedTaskContent in model EncodedTaskRunRequest"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
        if (this.platform() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property platform in model EncodedTaskRunRequest"));
        }
        this.platform().validate();
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled());
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName());
        jsonWriter.writeStringField("logTemplate", this.logTemplate());
        jsonWriter.writeStringField("encodedTaskContent", this.encodedTaskContent);
        jsonWriter.writeJsonField("platform", this.platform);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("encodedValuesContent", this.encodedValuesContent);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("timeout", this.timeout);
        jsonWriter.writeJsonField("agentConfiguration", this.agentConfiguration);
        jsonWriter.writeStringField("sourceLocation", this.sourceLocation);
        jsonWriter.writeJsonField("credentials", this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static EncodedTaskRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncodedTaskRunRequest deserializedEncodedTaskRunRequest = new EncodedTaskRunRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.withIsArchiveEnabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("agentPoolName".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.withAgentPoolName(reader.getString());
                    continue;
                }
                if ("logTemplate".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.withLogTemplate(reader.getString());
                    continue;
                }
                if ("encodedTaskContent".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.encodedTaskContent = reader.getString();
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.platform = PlatformProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.type = reader.getString();
                    continue;
                }
                if ("encodedValuesContent".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.encodedValuesContent = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List<SetValue> values2 = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    deserializedEncodedTaskRunRequest.values = values2;
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.timeout = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("agentConfiguration".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.agentConfiguration = AgentProperties.fromJson(reader);
                    continue;
                }
                if ("sourceLocation".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.sourceLocation = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedEncodedTaskRunRequest.credentials = Credentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncodedTaskRunRequest;
        });
    }
}

