/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ImportMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ImportSource;
import java.io.IOException;
import java.util.List;

public final class ImportImageParameters
implements JsonSerializable<ImportImageParameters> {
    private ImportSource source;
    private List<String> targetTags;
    private List<String> untaggedTargetRepositories;
    private ImportMode mode;
    private static final ClientLogger LOGGER = new ClientLogger(ImportImageParameters.class);

    public ImportSource source() {
        return this.source;
    }

    public ImportImageParameters withSource(ImportSource source2) {
        this.source = source2;
        return this;
    }

    public List<String> targetTags() {
        return this.targetTags;
    }

    public ImportImageParameters withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    public List<String> untaggedTargetRepositories() {
        return this.untaggedTargetRepositories;
    }

    public ImportImageParameters withUntaggedTargetRepositories(List<String> untaggedTargetRepositories) {
        this.untaggedTargetRepositories = untaggedTargetRepositories;
        return this;
    }

    public ImportMode mode() {
        return this.mode;
    }

    public ImportImageParameters withMode(ImportMode mode) {
        this.mode = mode;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property source in model ImportImageParameters"));
        }
        this.source().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeArrayField("targetTags", this.targetTags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("untaggedTargetRepositories", this.untaggedTargetRepositories, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ImportImageParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImportImageParameters deserializedImportImageParameters = new ImportImageParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedImportImageParameters.source = ImportSource.fromJson(reader);
                    continue;
                }
                if ("targetTags".equals(fieldName)) {
                    List<String> targetTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedImportImageParameters.targetTags = targetTags;
                    continue;
                }
                if ("untaggedTargetRepositories".equals(fieldName)) {
                    List<String> untaggedTargetRepositories = reader.readArray(reader1 -> reader1.getString());
                    deserializedImportImageParameters.untaggedTargetRepositories = untaggedTargetRepositories;
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedImportImageParameters.mode = ImportMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportImageParameters;
        });
    }
}

