/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TokenCertificateName;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TokenCertificate
implements JsonSerializable<TokenCertificate> {
    private TokenCertificateName name;
    private OffsetDateTime expiry;
    private String thumbprint;
    private String encodedPemCertificate;

    public TokenCertificateName name() {
        return this.name;
    }

    public TokenCertificate withName(TokenCertificateName name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime expiry() {
        return this.expiry;
    }

    public TokenCertificate withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public TokenCertificate withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public String encodedPemCertificate() {
        return this.encodedPemCertificate;
    }

    public TokenCertificate withEncodedPemCertificate(String encodedPemCertificate) {
        this.encodedPemCertificate = encodedPemCertificate;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("expiry", this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("encodedPemCertificate", this.encodedPemCertificate);
        return jsonWriter.writeEndObject();
    }

    public static TokenCertificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenCertificate deserializedTokenCertificate = new TokenCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTokenCertificate.name = TokenCertificateName.fromString(reader.getString());
                    continue;
                }
                if ("expiry".equals(fieldName)) {
                    deserializedTokenCertificate.expiry = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedTokenCertificate.thumbprint = reader.getString();
                    continue;
                }
                if ("encodedPemCertificate".equals(fieldName)) {
                    deserializedTokenCertificate.encodedPemCertificate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenCertificate;
        });
    }
}

