/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.ContainerServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.ContainerServiceManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.ManagedClustersClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models.CredentialResultsInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models.OrchestratorVersionProfileListResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.implementation.KubernetesClusterImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.ContainerServiceResourceTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.CredentialResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.Format;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.KubernetesCluster;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.KubernetesClusters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OrchestratorVersionProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class KubernetesClustersImpl
extends GroupableResourcesImpl<KubernetesCluster, KubernetesClusterImpl, ManagedClusterInner, ManagedClustersClient, ContainerServiceManager>
implements KubernetesClusters {
    public KubernetesClustersImpl(ContainerServiceManager containerServiceManager) {
        super(((ContainerServiceManagementClient)containerServiceManager.serviceClient()).getManagedClusters(), containerServiceManager);
    }

    @Override
    public PagedIterable<KubernetesCluster> list() {
        return new PagedIterable<KubernetesCluster>(this.listAsync());
    }

    @Override
    public PagedFlux<KubernetesCluster> listAsync() {
        return PagedConverter.mapPage(((ManagedClustersClient)this.inner()).listAsync(), inner -> new KubernetesClusterImpl(inner.name(), (ManagedClusterInner)inner, (ContainerServiceManager)this.manager()));
    }

    @Override
    public PagedIterable<KubernetesCluster> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<KubernetesCluster>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedFlux<KubernetesCluster> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<KubernetesCluster>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((ManagedClustersClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    protected Mono<ManagedClusterInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ManagedClustersClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((ManagedClustersClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    @Override
    protected KubernetesClusterImpl wrapModel(String name) {
        return new KubernetesClusterImpl(name, new ManagedClusterInner(), (ContainerServiceManager)this.manager());
    }

    @Override
    protected KubernetesClusterImpl wrapModel(ManagedClusterInner inner) {
        if (inner == null) {
            return null;
        }
        return new KubernetesClusterImpl(inner.name(), inner, (ContainerServiceManager)this.manager());
    }

    @Override
    public KubernetesClusterImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public Set<String> listKubernetesVersions(Region region) {
        TreeSet<String> kubernetesVersions = new TreeSet<String>();
        OrchestratorVersionProfileListResultInner inner = ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getContainerServices().listOrchestrators(region.name());
        if (inner != null && inner.orchestrators() != null && inner.orchestrators().size() > 0) {
            for (OrchestratorVersionProfile orchestrator : inner.orchestrators()) {
                if (!orchestrator.orchestratorType().equals("Kubernetes")) continue;
                kubernetesVersions.add(orchestrator.orchestratorVersion());
            }
        }
        return Collections.unmodifiableSet(kubernetesVersions);
    }

    @Override
    public Mono<Set<String>> listKubernetesVersionsAsync(Region region) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getContainerServices().listOrchestratorsAsync(region.name()).map(inner -> {
            TreeSet<String> kubernetesVersions = new TreeSet<String>();
            if (inner != null && inner.orchestrators() != null && inner.orchestrators().size() > 0) {
                for (OrchestratorVersionProfile orchestrator : inner.orchestrators()) {
                    if (!orchestrator.orchestratorType().equals("Kubernetes")) continue;
                    kubernetesVersions.add(orchestrator.orchestratorVersion());
                }
            }
            return Collections.unmodifiableSet(kubernetesVersions);
        });
    }

    @Override
    public PagedIterable<OrchestratorVersionProfile> listOrchestrators(Region region, ContainerServiceResourceTypes resourceTypes) {
        return new PagedIterable<OrchestratorVersionProfile>(this.listOrchestratorsAsync(region, resourceTypes));
    }

    @Override
    public PagedFlux<OrchestratorVersionProfile> listOrchestratorsAsync(Region region, ContainerServiceResourceTypes resourceTypes) {
        return new PagedFlux<OrchestratorVersionProfile>(() -> ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getContainerServices().listOrchestratorsWithResponseAsync(region.name(), resourceTypes.toString()).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue() == null || ((OrchestratorVersionProfileListResultInner)response.getValue()).orchestrators() == null ? Collections.emptyList() : ((OrchestratorVersionProfileListResultInner)response.getValue()).orchestrators(), null, null)));
    }

    @Override
    public List<CredentialResult> listAdminKubeConfigContent(String resourceGroupName, String kubernetesClusterName) {
        return this.listAdminKubeConfigContentAsync(resourceGroupName, kubernetesClusterName).block();
    }

    @Override
    public Mono<List<CredentialResult>> listAdminKubeConfigContentAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().listClusterAdminCredentialsAsync(resourceGroupName, kubernetesClusterName).map(CredentialResultsInner::kubeconfigs);
    }

    @Override
    public List<CredentialResult> listUserKubeConfigContent(String resourceGroupName, String kubernetesClusterName) {
        return this.listUserKubeConfigContentAsync(resourceGroupName, kubernetesClusterName).block();
    }

    @Override
    public List<CredentialResult> listUserKubeConfigContent(String resourceGroupName, String kubernetesClusterName, Format format) {
        return this.listUserKubeConfigContentAsync(resourceGroupName, kubernetesClusterName, format).block();
    }

    @Override
    public Mono<List<CredentialResult>> listUserKubeConfigContentAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().listClusterUserCredentialsAsync(resourceGroupName, kubernetesClusterName).map(CredentialResultsInner::kubeconfigs);
    }

    @Override
    public Mono<List<CredentialResult>> listUserKubeConfigContentAsync(String resourceGroupName, String kubernetesClusterName, Format format) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().listClusterUserCredentialsWithResponseAsync(resourceGroupName, kubernetesClusterName, null, format).map(response -> ((CredentialResultsInner)response.getValue()).kubeconfigs());
    }

    @Override
    public void start(String resourceGroupName, String kubernetesClusterName) {
        this.startAsync(resourceGroupName, kubernetesClusterName).block();
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().startAsync(resourceGroupName, kubernetesClusterName);
    }

    @Override
    public void stop(String resourceGroupName, String kubernetesClusterName) {
        this.stopAsync(resourceGroupName, kubernetesClusterName).block();
    }

    @Override
    public Mono<Void> stopAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().stopAsync(resourceGroupName, kubernetesClusterName);
    }
}

