/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OrchestratorProfile;
import java.io.IOException;
import java.util.List;

public final class OrchestratorVersionProfile
implements JsonSerializable<OrchestratorVersionProfile> {
    private String orchestratorType;
    private String orchestratorVersion;
    private Boolean defaultProperty;
    private Boolean isPreview;
    private List<OrchestratorProfile> upgrades;
    private static final ClientLogger LOGGER = new ClientLogger(OrchestratorVersionProfile.class);

    public String orchestratorType() {
        return this.orchestratorType;
    }

    public OrchestratorVersionProfile withOrchestratorType(String orchestratorType) {
        this.orchestratorType = orchestratorType;
        return this;
    }

    public String orchestratorVersion() {
        return this.orchestratorVersion;
    }

    public OrchestratorVersionProfile withOrchestratorVersion(String orchestratorVersion) {
        this.orchestratorVersion = orchestratorVersion;
        return this;
    }

    public Boolean defaultProperty() {
        return this.defaultProperty;
    }

    public OrchestratorVersionProfile withDefaultProperty(Boolean defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    public Boolean isPreview() {
        return this.isPreview;
    }

    public OrchestratorVersionProfile withIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    public List<OrchestratorProfile> upgrades() {
        return this.upgrades;
    }

    public OrchestratorVersionProfile withUpgrades(List<OrchestratorProfile> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    public void validate() {
        if (this.orchestratorType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property orchestratorType in model OrchestratorVersionProfile"));
        }
        if (this.orchestratorVersion() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property orchestratorVersion in model OrchestratorVersionProfile"));
        }
        if (this.upgrades() != null) {
            this.upgrades().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("orchestratorType", this.orchestratorType);
        jsonWriter.writeStringField("orchestratorVersion", this.orchestratorVersion);
        jsonWriter.writeBooleanField("default", this.defaultProperty);
        jsonWriter.writeBooleanField("isPreview", this.isPreview);
        jsonWriter.writeArrayField("upgrades", this.upgrades, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static OrchestratorVersionProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrchestratorVersionProfile deserializedOrchestratorVersionProfile = new OrchestratorVersionProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("orchestratorType".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.orchestratorType = reader.getString();
                    continue;
                }
                if ("orchestratorVersion".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.orchestratorVersion = reader.getString();
                    continue;
                }
                if ("default".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.defaultProperty = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isPreview".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.isPreview = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("upgrades".equals(fieldName)) {
                    List<OrchestratorProfile> upgrades = reader.readArray(reader1 -> OrchestratorProfile.fromJson(reader1));
                    deserializedOrchestratorVersionProfile.upgrades = upgrades;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrchestratorVersionProfile;
        });
    }
}

