/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.GraphApiComputeRegionalServiceResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class GraphApiComputeServiceResourceProperties
extends ServiceResourceProperties {
    private ServiceType serviceType = ServiceType.GRAPH_APICOMPUTE;
    private String graphApiComputeEndpoint;
    private List<GraphApiComputeRegionalServiceResource> locations;
    private ServiceStatus status;
    private OffsetDateTime creationTime;

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    public String graphApiComputeEndpoint() {
        return this.graphApiComputeEndpoint;
    }

    public GraphApiComputeServiceResourceProperties withGraphApiComputeEndpoint(String graphApiComputeEndpoint) {
        this.graphApiComputeEndpoint = graphApiComputeEndpoint;
        return this;
    }

    public List<GraphApiComputeRegionalServiceResource> locations() {
        return this.locations;
    }

    @Override
    public ServiceStatus status() {
        return this.status;
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public GraphApiComputeServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    @Override
    public GraphApiComputeServiceResourceProperties withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    @Override
    public void validate() {
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", this.instanceSize() == null ? null : this.instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", this.instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("graphApiComputeEndpoint", this.graphApiComputeEndpoint);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GraphApiComputeServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GraphApiComputeServiceResourceProperties deserializedGraphApiComputeServiceResourceProperties = new GraphApiComputeServiceResourceProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.creationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("instanceSize".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.withInstanceSize(ServiceSize.fromString(reader.getString()));
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.withInstanceCount(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.status = ServiceStatus.fromString(reader.getString());
                    continue;
                }
                if ("serviceType".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                if ("graphApiComputeEndpoint".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.graphApiComputeEndpoint = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List<GraphApiComputeRegionalServiceResource> locations = reader.readArray(reader1 -> GraphApiComputeRegionalServiceResource.fromJson(reader1));
                    deserializedGraphApiComputeServiceResourceProperties.locations = locations;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGraphApiComputeServiceResourceProperties.withAdditionalProperties(additionalProperties);
            return deserializedGraphApiComputeServiceResourceProperties;
        });
    }
}

