/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MaterializedViewsBuilderRegionalServiceResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MaterializedViewsBuilderServiceResourceProperties
extends ServiceResourceProperties {
    private ServiceType serviceType = ServiceType.MATERIALIZED_VIEWS_BUILDER;
    private List<MaterializedViewsBuilderRegionalServiceResource> locations;
    private ServiceStatus status;
    private OffsetDateTime creationTime;

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    public List<MaterializedViewsBuilderRegionalServiceResource> locations() {
        return this.locations;
    }

    @Override
    public ServiceStatus status() {
        return this.status;
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public MaterializedViewsBuilderServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    @Override
    public MaterializedViewsBuilderServiceResourceProperties withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    @Override
    public void validate() {
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", this.instanceSize() == null ? null : this.instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", this.instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MaterializedViewsBuilderServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaterializedViewsBuilderServiceResourceProperties deserializedMaterializedViewsBuilderServiceResourceProperties = new MaterializedViewsBuilderServiceResourceProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceProperties.creationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("instanceSize".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceProperties.withInstanceSize(ServiceSize.fromString(reader.getString()));
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceProperties.withInstanceCount(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceProperties.status = ServiceStatus.fromString(reader.getString());
                    continue;
                }
                if ("serviceType".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceProperties.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List<MaterializedViewsBuilderRegionalServiceResource> locations = reader.readArray(reader1 -> MaterializedViewsBuilderRegionalServiceResource.fromJson(reader1));
                    deserializedMaterializedViewsBuilderServiceResourceProperties.locations = locations;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMaterializedViewsBuilderServiceResourceProperties.withAdditionalProperties(additionalProperties);
            return deserializedMaterializedViewsBuilderServiceResourceProperties;
        });
    }
}

