/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MongoIndex;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class MongoDBCollectionResource
implements JsonSerializable<MongoDBCollectionResource> {
    private String id;
    private Map<String, String> shardKey;
    private List<MongoIndex> indexes;
    private Integer analyticalStorageTtl;
    private ResourceRestoreParameters restoreParameters;
    private CreateMode createMode;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDBCollectionResource.class);

    public String id() {
        return this.id;
    }

    public MongoDBCollectionResource withId(String id) {
        this.id = id;
        return this;
    }

    public Map<String, String> shardKey() {
        return this.shardKey;
    }

    public MongoDBCollectionResource withShardKey(Map<String, String> shardKey) {
        this.shardKey = shardKey;
        return this;
    }

    public List<MongoIndex> indexes() {
        return this.indexes;
    }

    public MongoDBCollectionResource withIndexes(List<MongoIndex> indexes) {
        this.indexes = indexes;
        return this;
    }

    public Integer analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    public MongoDBCollectionResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public MongoDBCollectionResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public MongoDBCollectionResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model MongoDBCollectionResource"));
        }
        if (this.indexes() != null) {
            this.indexes().forEach(e -> e.validate());
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeMapField("shardKey", this.shardKey, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("indexes", this.indexes, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("analyticalStorageTtl", this.analyticalStorageTtl);
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDBCollectionResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoDBCollectionResource deserializedMongoDBCollectionResource = new MongoDBCollectionResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMongoDBCollectionResource.id = reader.getString();
                    continue;
                }
                if ("shardKey".equals(fieldName)) {
                    Map<String, String> shardKey = reader.readMap(reader1 -> reader1.getString());
                    deserializedMongoDBCollectionResource.shardKey = shardKey;
                    continue;
                }
                if ("indexes".equals(fieldName)) {
                    List<MongoIndex> indexes = reader.readArray(reader1 -> MongoIndex.fromJson(reader1));
                    deserializedMongoDBCollectionResource.indexes = indexes;
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedMongoDBCollectionResource.analyticalStorageTtl = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedMongoDBCollectionResource.restoreParameters = ResourceRestoreParameters.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedMongoDBCollectionResource.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDBCollectionResource;
        });
    }
}

