/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.DisasterRecoveryPairingAuthorizationRulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubAuthorizationRulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubConsumerGroupsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubDisasterRecoveryPairingsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubNamespaceAuthorizationRulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubNamespacesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.DisasterRecoveryPairingAuthorizationRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubDisasterRecoveryPairings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubNamespaceAuthorizationRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubNamespaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import java.util.Objects;

public final class EventHubsManager
extends Manager<EventHubManagementClient> {
    private EventHubNamespaces namespaces;
    private EventHubs eventHubs;
    private EventHubConsumerGroups consumerGroups;
    private EventHubAuthorizationRules eventHubAuthorizationRules;
    private EventHubNamespaceAuthorizationRules namespaceAuthorizationRules;
    private EventHubDisasterRecoveryPairings eventHubDisasterRecoveryPairings;
    private DisasterRecoveryPairingAuthorizationRules disasterRecoveryPairingAuthorizationRules;
    private final StorageManager storageManager;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static EventHubsManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return EventHubsManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static EventHubsManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new EventHubsManager(httpPipeline, profile);
    }

    private EventHubsManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new EventHubManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.storageManager = StorageManager.authenticate(httpPipeline, profile);
    }

    public EventHubNamespaces namespaces() {
        if (this.namespaces == null) {
            this.namespaces = new EventHubNamespacesImpl(this);
        }
        return this.namespaces;
    }

    public EventHubs eventHubs() {
        if (this.eventHubs == null) {
            this.eventHubs = new EventHubsImpl(this, this.storageManager);
        }
        return this.eventHubs;
    }

    public EventHubConsumerGroups consumerGroups() {
        if (this.consumerGroups == null) {
            this.consumerGroups = new EventHubConsumerGroupsImpl(this);
        }
        return this.consumerGroups;
    }

    public EventHubDisasterRecoveryPairings eventHubDisasterRecoveryPairings() {
        if (this.eventHubDisasterRecoveryPairings == null) {
            this.eventHubDisasterRecoveryPairings = new EventHubDisasterRecoveryPairingsImpl(this);
        }
        return this.eventHubDisasterRecoveryPairings;
    }

    public EventHubAuthorizationRules eventHubAuthorizationRules() {
        if (this.eventHubAuthorizationRules == null) {
            this.eventHubAuthorizationRules = new EventHubAuthorizationRulesImpl(this);
        }
        return this.eventHubAuthorizationRules;
    }

    public EventHubNamespaceAuthorizationRules namespaceAuthorizationRules() {
        if (this.namespaceAuthorizationRules == null) {
            this.namespaceAuthorizationRules = new EventHubNamespaceAuthorizationRulesImpl(this);
        }
        return this.namespaceAuthorizationRules;
    }

    public DisasterRecoveryPairingAuthorizationRules disasterRecoveryPairingAuthorizationRules() {
        if (this.disasterRecoveryPairingAuthorizationRules == null) {
            this.disasterRecoveryPairingAuthorizationRules = new DisasterRecoveryPairingAuthorizationRulesImpl(this);
        }
        return this.disasterRecoveryPairingAuthorizationRules;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public EventHubsManager authenticate(TokenCredential credential, AzureProfile profile) {
            return EventHubsManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public EventHubsManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

