/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.AuthorizationRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.AuthorizationRulesBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubAuthorizationRuleImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public final class EventHubAuthorizationRulesImpl
extends AuthorizationRulesBaseImpl<EventHubsClient, EventHubAuthorizationRule, EventHubAuthorizationRuleImpl>
implements EventHubAuthorizationRules {
    public EventHubAuthorizationRulesImpl(EventHubsManager manager) {
        super(manager, ((EventHubManagementClient)manager.serviceClient()).getEventHubs());
    }

    @Override
    public EventHubAuthorizationRuleImpl define(String name) {
        return new EventHubAuthorizationRuleImpl(name, this.manager);
    }

    @Override
    public Mono<EventHubAuthorizationRule> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString(id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public EventHubAuthorizationRule getByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return this.getByNameAsync(resourceGroupName, namespaceName, eventHubName, name).block();
    }

    @Override
    public Mono<EventHubAuthorizationRule> getByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((EventHubsClient)this.innerModel()).getAuthorizationRuleAsync(resourceGroupName, namespaceName, eventHubName, name).map(this::wrapModel);
    }

    @Override
    public PagedIterable<EventHubAuthorizationRule> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        return PagedConverter.mapPage(((EventHubsClient)this.innerModel()).listAuthorizationRules(resourceGroupName, namespaceName, eventHubName), this::wrapModel);
    }

    @Override
    public PagedFlux<EventHubAuthorizationRule> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return PagedConverter.mapPage(((EventHubsClient)this.innerModel()).listAuthorizationRulesAsync(resourceGroupName, namespaceName, eventHubName), this::wrapModel);
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString(id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, eventHubName, name).block();
    }

    @Override
    public Mono<Void> deleteByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((EventHubsClient)this.innerModel()).deleteAuthorizationRuleAsync(resourceGroupName, namespaceName, eventHubName, name);
    }

    @Override
    protected EventHubAuthorizationRuleImpl wrapModel(AuthorizationRuleInner innerModel) {
        return new EventHubAuthorizationRuleImpl(innerModel.name(), innerModel, this.manager);
    }
}

