/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.KeyImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Key;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Keys;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyProperties;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

class KeysImpl
extends CreatableWrappersImpl<Key, KeyImpl, KeyProperties>
implements Keys {
    private final KeyAsyncClient inner;
    private final HttpPipeline httpPipeline;
    private final KeyAsyncClient keyClient;

    KeysImpl(KeyAsyncClient client, HttpPipeline httpPipeline) {
        this.inner = client;
        this.httpPipeline = httpPipeline;
        this.keyClient = client;
    }

    @Override
    public KeyImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected KeyImpl wrapModel(String name) {
        return new KeyImpl(name, new KeyProperties(), this.httpPipeline, this.keyClient);
    }

    @Override
    public Key getById(String id) {
        return this.getByIdAsync(id).block();
    }

    @Override
    public Mono<Key> getByIdAsync(String id) {
        String name = KeysImpl.nameFromId(id);
        String version = KeysImpl.versionFromId(id);
        return this.getByNameAndVersionAsync(name, version);
    }

    @Override
    protected KeyImpl wrapModel(KeyProperties keyProperties) {
        if (keyProperties == null) {
            return null;
        }
        return new KeyImpl(keyProperties.getName(), keyProperties, this.httpPipeline, this.keyClient);
    }

    @Override
    protected KeyImpl wrapModel(KeyVaultKey keyVaultKey) {
        if (keyVaultKey == null) {
            return null;
        }
        return new KeyImpl(keyVaultKey.getName(), keyVaultKey, this.httpPipeline, this.keyClient);
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        String name = KeysImpl.nameFromId(id);
        return this.inner.beginDeleteKey(name).last().flatMap(asyncPollResponse -> {
            if (asyncPollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
                return asyncPollResponse.getFinalResult();
            }
            return Mono.error(new RuntimeException("polling completed unsuccessfully with status:" + asyncPollResponse.getStatus()));
        });
    }

    @Override
    public PagedIterable<Key> list() {
        return new PagedIterable<Key>(this.listAsync());
    }

    @Override
    public PagedFlux<Key> listAsync() {
        return PagedConverter.mapPage(this.inner.listPropertiesOfKeys(), this::wrapModel);
    }

    @Override
    public Key getByNameAndVersion(String name, String version) {
        return this.getByNameAndVersionAsync(name, version).block();
    }

    @Override
    public Mono<Key> getByNameAndVersionAsync(String name, String version) {
        Objects.requireNonNull(name);
        return (version == null ? this.inner.getKey(name) : this.inner.getKey(name, version)).map(this::wrapModel);
    }

    @Override
    public Key restore(byte[] backup) {
        return this.restoreAsync(backup).block();
    }

    @Override
    public Mono<Key> restoreAsync(byte[] backup) {
        return this.inner.restoreKeyBackup(backup).map(this::wrapModel);
    }

    @Override
    public Mono<Key> getByNameAsync(String name) {
        return this.inner.getKey(name).map(this::wrapModel);
    }

    @Override
    public Key getByName(String name) {
        return this.getByNameAsync(name).block();
    }

    private static String nameFromId(String id) {
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            String name = tokens.length >= 3 ? tokens[2] : null;
            return name;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Received Malformed Id URL from KV Service");
        }
    }

    private static String versionFromId(String id) {
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            String version = tokens.length >= 4 ? tokens[3] : null;
            return version;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Received Malformed Id URL from KV Service");
        }
    }
}

