/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AccessModeSettings;
import java.io.IOException;
import java.util.List;

public final class AzureMonitorPrivateLinkScopeProperties
implements JsonSerializable<AzureMonitorPrivateLinkScopeProperties> {
    private String provisioningState;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private AccessModeSettings accessModeSettings;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorPrivateLinkScopeProperties.class);

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public AccessModeSettings accessModeSettings() {
        return this.accessModeSettings;
    }

    public AzureMonitorPrivateLinkScopeProperties withAccessModeSettings(AccessModeSettings accessModeSettings) {
        this.accessModeSettings = accessModeSettings;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.accessModeSettings() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property accessModeSettings in model AzureMonitorPrivateLinkScopeProperties"));
        }
        this.accessModeSettings().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("accessModeSettings", this.accessModeSettings);
        return jsonWriter.writeEndObject();
    }

    public static AzureMonitorPrivateLinkScopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureMonitorPrivateLinkScopeProperties deserializedAzureMonitorPrivateLinkScopeProperties = new AzureMonitorPrivateLinkScopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessModeSettings".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeProperties.accessModeSettings = AccessModeSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedAzureMonitorPrivateLinkScopeProperties.privateEndpointConnections = privateEndpointConnections;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMonitorPrivateLinkScopeProperties;
        });
    }
}

