/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.MetricAlertProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class MetricAlertResourceInner
extends Resource {
    private MetricAlertProperties innerProperties = new MetricAlertProperties();
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(MetricAlertResourceInner.class);

    private MetricAlertProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public MetricAlertResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public MetricAlertResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public MetricAlertResourceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public int severity() {
        return this.innerProperties() == null ? 0 : this.innerProperties().severity();
    }

    public MetricAlertResourceInner withSeverity(int severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    public boolean enabled() {
        return this.innerProperties() == null ? false : this.innerProperties().enabled();
    }

    public MetricAlertResourceInner withEnabled(boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    public MetricAlertResourceInner withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    public Duration evaluationFrequency() {
        return this.innerProperties() == null ? null : this.innerProperties().evaluationFrequency();
    }

    public MetricAlertResourceInner withEvaluationFrequency(Duration evaluationFrequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withEvaluationFrequency(evaluationFrequency);
        return this;
    }

    public Duration windowSize() {
        return this.innerProperties() == null ? null : this.innerProperties().windowSize();
    }

    public MetricAlertResourceInner withWindowSize(Duration windowSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withWindowSize(windowSize);
        return this;
    }

    public String targetResourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceType();
    }

    public MetricAlertResourceInner withTargetResourceType(String targetResourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withTargetResourceType(targetResourceType);
        return this;
    }

    public String targetResourceRegion() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceRegion();
    }

    public MetricAlertResourceInner withTargetResourceRegion(String targetResourceRegion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withTargetResourceRegion(targetResourceRegion);
        return this;
    }

    public MetricAlertCriteria criteria() {
        return this.innerProperties() == null ? null : this.innerProperties().criteria();
    }

    public MetricAlertResourceInner withCriteria(MetricAlertCriteria criteria) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withCriteria(criteria);
        return this;
    }

    public Boolean autoMitigate() {
        return this.innerProperties() == null ? null : this.innerProperties().autoMitigate();
    }

    public MetricAlertResourceInner withAutoMitigate(Boolean autoMitigate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withAutoMitigate(autoMitigate);
        return this;
    }

    public List<MetricAlertAction> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public MetricAlertResourceInner withActions(List<MetricAlertAction> actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertProperties();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastUpdatedTime();
    }

    public Boolean isMigrated() {
        return this.innerProperties() == null ? null : this.innerProperties().isMigrated();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model MetricAlertResourceInner"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MetricAlertResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertResourceInner deserializedMetricAlertResourceInner = new MetricAlertResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMetricAlertResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetricAlertResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMetricAlertResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMetricAlertResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMetricAlertResourceInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMetricAlertResourceInner.innerProperties = MetricAlertProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricAlertResourceInner;
        });
    }
}

