/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DimensionOperator;
import java.io.IOException;
import java.util.List;

public final class Dimension
implements JsonSerializable<Dimension> {
    private String name;
    private DimensionOperator operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(Dimension.class);

    public String name() {
        return this.name;
    }

    public Dimension withName(String name) {
        this.name = name;
        return this;
    }

    public DimensionOperator operator() {
        return this.operator;
    }

    public Dimension withOperator(DimensionOperator operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public Dimension withValues(List<String> values2) {
        this.values = values2;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Dimension"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model Dimension"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property values in model Dimension"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static Dimension fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Dimension deserializedDimension = new Dimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDimension.name = reader.getString();
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedDimension.operator = DimensionOperator.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List<String> values2 = reader.readArray(reader1 -> reader1.getString());
                    deserializedDimension.values = values2;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDimension;
        });
    }
}

