/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.fluent.models.UserAssignedIdentityProperties;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class IdentityInner
extends Resource {
    private UserAssignedIdentityProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private UserAssignedIdentityProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public IdentityInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public IdentityInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public UUID tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public UUID principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public UUID clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static IdentityInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IdentityInner deserializedIdentityInner = new IdentityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIdentityInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIdentityInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIdentityInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIdentityInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIdentityInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIdentityInner.innerProperties = UserAssignedIdentityProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedIdentityInner.systemData = SystemData.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityInner;
        });
    }
}

