/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.ProxyResource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.fluent.models.UserAssignedIdentityProperties;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class IdentityUpdate
extends ProxyResource {
    private String location;
    private Map<String, String> tags;
    private UserAssignedIdentityProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public String location() {
        return this.location;
    }

    public IdentityUpdate withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public IdentityUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private UserAssignedIdentityProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    public UUID tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public UUID principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public UUID clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static IdentityUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IdentityUpdate deserializedIdentityUpdate = new IdentityUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIdentityUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIdentityUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIdentityUpdate.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIdentityUpdate.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIdentityUpdate.tags = tags;
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIdentityUpdate.innerProperties = UserAssignedIdentityProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedIdentityUpdate.systemData = SystemData.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityUpdate;
        });
    }
}

