/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFirewallRuleGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayTierTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayFirewallRuleSetPropertiesFormat
implements JsonSerializable<ApplicationGatewayFirewallRuleSetPropertiesFormat> {
    private ProvisioningState provisioningState;
    private String ruleSetType;
    private String ruleSetVersion;
    private List<ApplicationGatewayFirewallRuleGroup> ruleGroups;
    private List<ApplicationGatewayTierTypes> tiers;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationGatewayFirewallRuleSetPropertiesFormat.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String ruleSetType() {
        return this.ruleSetType;
    }

    public ApplicationGatewayFirewallRuleSetPropertiesFormat withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    public ApplicationGatewayFirewallRuleSetPropertiesFormat withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    public List<ApplicationGatewayFirewallRuleGroup> ruleGroups() {
        return this.ruleGroups;
    }

    public ApplicationGatewayFirewallRuleSetPropertiesFormat withRuleGroups(List<ApplicationGatewayFirewallRuleGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

    public List<ApplicationGatewayTierTypes> tiers() {
        return this.tiers;
    }

    public ApplicationGatewayFirewallRuleSetPropertiesFormat withTiers(List<ApplicationGatewayTierTypes> tiers) {
        this.tiers = tiers;
        return this;
    }

    public void validate() {
        if (this.ruleSetType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleSetType in model ApplicationGatewayFirewallRuleSetPropertiesFormat"));
        }
        if (this.ruleSetVersion() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleSetVersion in model ApplicationGatewayFirewallRuleSetPropertiesFormat"));
        }
        if (this.ruleGroups() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleGroups in model ApplicationGatewayFirewallRuleSetPropertiesFormat"));
        }
        this.ruleGroups().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleSetType", this.ruleSetType);
        jsonWriter.writeStringField("ruleSetVersion", this.ruleSetVersion);
        jsonWriter.writeArrayField("ruleGroups", this.ruleGroups, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("tiers", this.tiers, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayFirewallRuleSetPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayFirewallRuleSetPropertiesFormat deserializedApplicationGatewayFirewallRuleSetPropertiesFormat = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleSetType".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSetPropertiesFormat.ruleSetType = reader.getString();
                    continue;
                }
                if ("ruleSetVersion".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSetPropertiesFormat.ruleSetVersion = reader.getString();
                    continue;
                }
                if ("ruleGroups".equals(fieldName)) {
                    List<ApplicationGatewayFirewallRuleGroup> ruleGroups = reader.readArray(reader1 -> ApplicationGatewayFirewallRuleGroup.fromJson(reader1));
                    deserializedApplicationGatewayFirewallRuleSetPropertiesFormat.ruleGroups = ruleGroups;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSetPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("tiers".equals(fieldName)) {
                    List<ApplicationGatewayTierTypes> tiers = reader.readArray(reader1 -> ApplicationGatewayTierTypes.fromString(reader1.getString()));
                    deserializedApplicationGatewayFirewallRuleSetPropertiesFormat.tiers = tiers;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayFirewallRuleSetPropertiesFormat;
        });
    }
}

