/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AzureReachabilityReportItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AzureReachabilityReportLocation;
import java.io.IOException;
import java.util.List;

public final class AzureReachabilityReportInner
implements JsonSerializable<AzureReachabilityReportInner> {
    private String aggregationLevel;
    private AzureReachabilityReportLocation providerLocation;
    private List<AzureReachabilityReportItem> reachabilityReport;
    private static final ClientLogger LOGGER = new ClientLogger(AzureReachabilityReportInner.class);

    public String aggregationLevel() {
        return this.aggregationLevel;
    }

    public AzureReachabilityReportInner withAggregationLevel(String aggregationLevel) {
        this.aggregationLevel = aggregationLevel;
        return this;
    }

    public AzureReachabilityReportLocation providerLocation() {
        return this.providerLocation;
    }

    public AzureReachabilityReportInner withProviderLocation(AzureReachabilityReportLocation providerLocation) {
        this.providerLocation = providerLocation;
        return this;
    }

    public List<AzureReachabilityReportItem> reachabilityReport() {
        return this.reachabilityReport;
    }

    public AzureReachabilityReportInner withReachabilityReport(List<AzureReachabilityReportItem> reachabilityReport) {
        this.reachabilityReport = reachabilityReport;
        return this;
    }

    public void validate() {
        if (this.aggregationLevel() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property aggregationLevel in model AzureReachabilityReportInner"));
        }
        if (this.providerLocation() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property providerLocation in model AzureReachabilityReportInner"));
        }
        this.providerLocation().validate();
        if (this.reachabilityReport() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property reachabilityReport in model AzureReachabilityReportInner"));
        }
        this.reachabilityReport().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("aggregationLevel", this.aggregationLevel);
        jsonWriter.writeJsonField("providerLocation", this.providerLocation);
        jsonWriter.writeArrayField("reachabilityReport", this.reachabilityReport, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureReachabilityReportInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureReachabilityReportInner deserializedAzureReachabilityReportInner = new AzureReachabilityReportInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("aggregationLevel".equals(fieldName)) {
                    deserializedAzureReachabilityReportInner.aggregationLevel = reader.getString();
                    continue;
                }
                if ("providerLocation".equals(fieldName)) {
                    deserializedAzureReachabilityReportInner.providerLocation = AzureReachabilityReportLocation.fromJson(reader);
                    continue;
                }
                if ("reachabilityReport".equals(fieldName)) {
                    List<AzureReachabilityReportItem> reachabilityReport = reader.readArray(reader1 -> AzureReachabilityReportItem.fromJson(reader1));
                    deserializedAzureReachabilityReportInner.reachabilityReport = reachabilityReport;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureReachabilityReportInner;
        });
    }
}

