/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.BgpServiceCommunityPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.BgpCommunity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BgpServiceCommunityInner
extends Resource {
    private BgpServiceCommunityPropertiesFormat innerProperties;
    private String id;
    private String type;
    private String name;

    private BgpServiceCommunityPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    public BgpServiceCommunityInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BgpServiceCommunityInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public BgpServiceCommunityInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String serviceName() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceName();
    }

    public BgpServiceCommunityInner withServiceName(String serviceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpServiceCommunityPropertiesFormat();
        }
        this.innerProperties().withServiceName(serviceName);
        return this;
    }

    public List<BgpCommunity> bgpCommunities() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpCommunities();
    }

    public BgpServiceCommunityInner withBgpCommunities(List<BgpCommunity> bgpCommunities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpServiceCommunityPropertiesFormat();
        }
        this.innerProperties().withBgpCommunities(bgpCommunities);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static BgpServiceCommunityInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpServiceCommunityInner deserializedBgpServiceCommunityInner = new BgpServiceCommunityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBgpServiceCommunityInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.innerProperties = BgpServiceCommunityPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpServiceCommunityInner;
        });
    }
}

