/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;
import java.util.List;

public final class NetworkVirtualApplianceConnectionProperties
implements JsonSerializable<NetworkVirtualApplianceConnectionProperties> {
    private String name;
    private ProvisioningState provisioningState;
    private Long asn;
    private Long tunnelIdentifier;
    private List<String> bgpPeerAddress;
    private Boolean enableInternetSecurity;
    private RoutingConfiguration routingConfiguration;

    public String name() {
        return this.name;
    }

    public NetworkVirtualApplianceConnectionProperties withName(String name) {
        this.name = name;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Long asn() {
        return this.asn;
    }

    public NetworkVirtualApplianceConnectionProperties withAsn(Long asn) {
        this.asn = asn;
        return this;
    }

    public Long tunnelIdentifier() {
        return this.tunnelIdentifier;
    }

    public NetworkVirtualApplianceConnectionProperties withTunnelIdentifier(Long tunnelIdentifier) {
        this.tunnelIdentifier = tunnelIdentifier;
        return this;
    }

    public List<String> bgpPeerAddress() {
        return this.bgpPeerAddress;
    }

    public NetworkVirtualApplianceConnectionProperties withBgpPeerAddress(List<String> bgpPeerAddress) {
        this.bgpPeerAddress = bgpPeerAddress;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public NetworkVirtualApplianceConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public NetworkVirtualApplianceConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public void validate() {
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("asn", this.asn);
        jsonWriter.writeNumberField("tunnelIdentifier", this.tunnelIdentifier);
        jsonWriter.writeArrayField("bgpPeerAddress", this.bgpPeerAddress, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("enableInternetSecurity", this.enableInternetSecurity);
        jsonWriter.writeJsonField("routingConfiguration", this.routingConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static NetworkVirtualApplianceConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkVirtualApplianceConnectionProperties deserializedNetworkVirtualApplianceConnectionProperties = new NetworkVirtualApplianceConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceConnectionProperties.name = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("asn".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceConnectionProperties.asn = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("tunnelIdentifier".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceConnectionProperties.tunnelIdentifier = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("bgpPeerAddress".equals(fieldName)) {
                    List<String> bgpPeerAddress = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkVirtualApplianceConnectionProperties.bgpPeerAddress = bgpPeerAddress;
                    continue;
                }
                if ("enableInternetSecurity".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceConnectionProperties.enableInternetSecurity = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("routingConfiguration".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceConnectionProperties.routingConfiguration = RoutingConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkVirtualApplianceConnectionProperties;
        });
    }
}

