/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Access;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteFilterRuleType;
import java.io.IOException;
import java.util.List;

public final class RouteFilterRulePropertiesFormat
implements JsonSerializable<RouteFilterRulePropertiesFormat> {
    private Access access;
    private RouteFilterRuleType routeFilterRuleType;
    private List<String> communities;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(RouteFilterRulePropertiesFormat.class);

    public Access access() {
        return this.access;
    }

    public RouteFilterRulePropertiesFormat withAccess(Access access) {
        this.access = access;
        return this;
    }

    public RouteFilterRuleType routeFilterRuleType() {
        return this.routeFilterRuleType;
    }

    public RouteFilterRulePropertiesFormat withRouteFilterRuleType(RouteFilterRuleType routeFilterRuleType) {
        this.routeFilterRuleType = routeFilterRuleType;
        return this;
    }

    public List<String> communities() {
        return this.communities;
    }

    public RouteFilterRulePropertiesFormat withCommunities(List<String> communities) {
        this.communities = communities;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.access() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property access in model RouteFilterRulePropertiesFormat"));
        }
        if (this.routeFilterRuleType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property routeFilterRuleType in model RouteFilterRulePropertiesFormat"));
        }
        if (this.communities() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property communities in model RouteFilterRulePropertiesFormat"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeStringField("routeFilterRuleType", this.routeFilterRuleType == null ? null : this.routeFilterRuleType.toString());
        jsonWriter.writeArrayField("communities", this.communities, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static RouteFilterRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteFilterRulePropertiesFormat deserializedRouteFilterRulePropertiesFormat = new RouteFilterRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("access".equals(fieldName)) {
                    deserializedRouteFilterRulePropertiesFormat.access = Access.fromString(reader.getString());
                    continue;
                }
                if ("routeFilterRuleType".equals(fieldName)) {
                    deserializedRouteFilterRulePropertiesFormat.routeFilterRuleType = RouteFilterRuleType.fromString(reader.getString());
                    continue;
                }
                if ("communities".equals(fieldName)) {
                    List<String> communities = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteFilterRulePropertiesFormat.communities = communities;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRouteFilterRulePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteFilterRulePropertiesFormat;
        });
    }
}

