/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddressPool;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class ApplicationGatewayBackendImpl
extends ChildResourceImpl<ApplicationGatewayBackendAddressPool, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayBackend,
ApplicationGatewayBackend.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayBackend.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayBackend.Update {
    ApplicationGatewayBackendImpl(ApplicationGatewayBackendAddressPool inner, ApplicationGatewayImpl parent) {
        super(inner, parent);
    }

    private List<ApplicationGatewayBackendAddress> ensureAddresses() {
        List<ApplicationGatewayBackendAddress> addresses = ((ApplicationGatewayBackendAddressPool)this.innerModel()).backendAddresses();
        if (addresses == null) {
            addresses = new ArrayList<ApplicationGatewayBackendAddress>();
            ((ApplicationGatewayBackendAddressPool)this.innerModel()).withBackendAddresses(addresses);
        }
        return addresses;
    }

    @Override
    public String name() {
        return ((ApplicationGatewayBackendAddressPool)this.innerModel()).name();
    }

    @Override
    public Map<String, String> backendNicIPConfigurationNames() {
        TreeMap<String, String> ipConfigNames = new TreeMap<String, String>();
        if (((ApplicationGatewayBackendAddressPool)this.innerModel()).backendIpConfigurations() != null) {
            for (NetworkInterfaceIpConfigurationInner inner : ((ApplicationGatewayBackendAddressPool)this.innerModel()).backendIpConfigurations()) {
                String nicId = ResourceUtils.parentResourceIdFromResourceId(inner.id());
                String ipConfigName = ResourceUtils.nameFromResourceId(inner.id());
                ipConfigNames.put(nicId, ipConfigName);
            }
        }
        return Collections.unmodifiableMap(ipConfigNames);
    }

    @Override
    public Collection<ApplicationGatewayBackendAddress> addresses() {
        ArrayList<ApplicationGatewayBackendAddress> addresses = new ArrayList<ApplicationGatewayBackendAddress>();
        if (((ApplicationGatewayBackendAddressPool)this.innerModel()).backendAddresses() != null) {
            for (ApplicationGatewayBackendAddress address : ((ApplicationGatewayBackendAddressPool)this.innerModel()).backendAddresses()) {
                addresses.add(address);
            }
        }
        return Collections.unmodifiableCollection(addresses);
    }

    @Override
    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withBackend(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    @Override
    public ApplicationGatewayBackendImpl withIPAddress(String ipAddress) {
        if (ipAddress == null) {
            return this;
        }
        ApplicationGatewayBackendAddress address = new ApplicationGatewayBackendAddress().withIpAddress(ipAddress);
        List<ApplicationGatewayBackendAddress> addresses = this.ensureAddresses();
        for (ApplicationGatewayBackendAddress a : addresses) {
            if (!ipAddress.equalsIgnoreCase(a.ipAddress())) continue;
            return this;
        }
        addresses.add(address);
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withFqdn(String fqdn) {
        if (fqdn == null) {
            return this;
        }
        ApplicationGatewayBackendAddress address = new ApplicationGatewayBackendAddress().withFqdn(fqdn);
        this.ensureAddresses().add(address);
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withoutIPAddress(String ipAddress) {
        if (ipAddress == null) {
            return this;
        }
        if (((ApplicationGatewayBackendAddressPool)this.innerModel()).backendAddresses() == null) {
            return this;
        }
        List<ApplicationGatewayBackendAddress> addresses = this.ensureAddresses();
        for (int i = 0; i < addresses.size(); ++i) {
            String curIPAddress = addresses.get(i).ipAddress();
            if (curIPAddress == null || !curIPAddress.equalsIgnoreCase(ipAddress)) continue;
            addresses.remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withoutAddress(ApplicationGatewayBackendAddress address) {
        this.ensureAddresses().remove(address);
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withoutFqdn(String fqdn) {
        if (fqdn == null) {
            return this;
        }
        List<ApplicationGatewayBackendAddress> addresses = this.ensureAddresses();
        for (int i = 0; i < addresses.size(); ++i) {
            String curFqdn = addresses.get(i).fqdn();
            if (curFqdn == null || !curFqdn.equalsIgnoreCase(fqdn)) continue;
            addresses.remove(i);
            break;
        }
        return this;
    }

    @Override
    public boolean containsIPAddress(String ipAddress) {
        if (ipAddress != null) {
            for (ApplicationGatewayBackendAddress address : ((ApplicationGatewayBackendAddressPool)this.innerModel()).backendAddresses()) {
                if (!ipAddress.equalsIgnoreCase(address.ipAddress())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsFqdn(String fqdn) {
        if (fqdn != null) {
            for (ApplicationGatewayBackendAddress address : ((ApplicationGatewayBackendAddressPool)this.innerModel()).backendAddresses()) {
                if (!fqdn.equalsIgnoreCase(address.fqdn())) continue;
                return true;
            }
        }
        return false;
    }
}

