/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.Utils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFrontend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFrontendIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Subnet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class ApplicationGatewayFrontendImpl
extends ChildResourceImpl<ApplicationGatewayFrontendIpConfiguration, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayFrontend,
ApplicationGatewayFrontend.Definition<ApplicationGateway.DefinitionStages.WithListener>,
ApplicationGatewayFrontend.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayFrontend.Update {
    ApplicationGatewayFrontendImpl(ApplicationGatewayFrontendIpConfiguration inner, ApplicationGatewayImpl parent) {
        super(inner, parent);
    }

    @Override
    public String networkId() {
        SubResource subnetRef = ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId(subnetRef.id());
        }
        return null;
    }

    @Override
    public String subnetName() {
        SubResource subnetRef = ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId(subnetRef.id());
        }
        return null;
    }

    @Override
    public String privateIpAddress() {
        return ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).privateIpAddress();
    }

    @Override
    public IpAllocationMethod privateIpAllocationMethod() {
        return ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).privateIpAllocationMethod();
    }

    @Override
    public String name() {
        return ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).name();
    }

    @Override
    public String publicIpAddressId() {
        if (((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).publicIpAddress() != null) {
            return ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).publicIpAddress().id();
        }
        return null;
    }

    @Override
    public boolean isPublic() {
        return ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).publicIpAddress() != null;
    }

    @Override
    public boolean isPrivate() {
        return ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).subnet() != null;
    }

    public ApplicationGatewayFrontendImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    @Override
    public ApplicationGatewayFrontendImpl withExistingSubnet(String parentNetworkResourceId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(parentNetworkResourceId + "/subnets/" + subnetName);
        ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).withSubnet(subnetRef);
        this.withoutPublicIpAddress();
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withExistingPublicIpAddress(PublicIpAddress pip) {
        return this.withExistingPublicIpAddress(pip.id());
    }

    @Override
    public ApplicationGatewayFrontendImpl withExistingPublicIpAddress(String resourceId) {
        SubResource pipRef = new SubResource().withId(resourceId);
        ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).withPublicIpAddress(pipRef);
        this.withoutSubnet();
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withoutPublicIpAddress() {
        ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).withPublicIpAddress(null);
        return this;
    }

    public ApplicationGatewayFrontendImpl withoutSubnet() {
        ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).withSubnet(null).withPrivateIpAddress(null).withPrivateIpAllocationMethod(null);
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withPrivateIpAddressDynamic() {
        ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).withPrivateIpAddress(null).withPrivateIpAllocationMethod(IpAllocationMethod.DYNAMIC);
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withPrivateIpAddressStatic(String ipAddress) {
        ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).withPrivateIpAddress(ipAddress).withPrivateIpAllocationMethod(IpAllocationMethod.STATIC);
        return this;
    }

    @Override
    public Subnet getSubnet() {
        return Utils.getAssociatedSubnet((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager(), ((ApplicationGatewayFrontendIpConfiguration)this.innerModel()).subnet());
    }

    @Override
    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withFrontend(this);
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        return this.getPublicIpAddressAsync().block();
    }

    @Override
    public Mono<PublicIpAddress> getPublicIpAddressAsync() {
        String pipId = this.publicIpAddressId();
        return pipId == null ? Mono.empty() : ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIpAddresses().getByIdAsync(pipId);
    }
}

