/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationGatewayRequestRoutingRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendHttpConfigurationImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayListenerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayRedirectConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRuleType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayUrlPathMap;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class ApplicationGatewayRequestRoutingRuleImpl
extends ChildResourceImpl<ApplicationGatewayRequestRoutingRuleInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayRequestRoutingRule,
ApplicationGatewayRequestRoutingRule.Definition<ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate>,
ApplicationGatewayRequestRoutingRule.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayRequestRoutingRule.Update {
    private Boolean associateWithPublicFrontend = null;

    ApplicationGatewayRequestRoutingRuleImpl(ApplicationGatewayRequestRoutingRuleInner inner, ApplicationGatewayImpl parent) {
        super(inner, parent);
    }

    @Override
    public Collection<ApplicationGatewayBackendAddress> backendAddresses() {
        Collection<Object> addresses = new ArrayList();
        ApplicationGatewayBackend backend = this.backend();
        if (backend != null && backend.addresses() != null) {
            addresses = backend.addresses();
        }
        return Collections.unmodifiableCollection(addresses);
    }

    @Override
    public ApplicationGatewayUrlPathMap urlPathMap() {
        SubResource urlMapRef = ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).urlPathMap();
        if (urlMapRef != null) {
            String urlMapName = ResourceUtils.nameFromResourceId(urlMapRef.id());
            return ((ApplicationGatewayImpl)this.parent()).urlPathMaps().get(urlMapName);
        }
        return null;
    }

    @Override
    public Integer priority() {
        return ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).priority();
    }

    @Override
    public boolean cookieBasedAffinity() {
        ApplicationGatewayBackendHttpConfigurationImpl backendConfig = this.backendHttpConfiguration();
        return backendConfig != null ? backendConfig.cookieBasedAffinity() : false;
    }

    @Override
    public int backendPort() {
        ApplicationGatewayBackendHttpConfigurationImpl backendConfig = this.backendHttpConfiguration();
        return backendConfig != null ? backendConfig.port() : 0;
    }

    @Override
    public boolean requiresServerNameIndication() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.requiresServerNameIndication() : false;
    }

    @Override
    public String hostname() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.hostname() : null;
    }

    @Override
    public List<String> hostnames() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.hostnames() : Collections.emptyList();
    }

    @Override
    public int frontendPort() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.frontendPortNumber() : 0;
    }

    @Override
    public ApplicationGatewaySslCertificate sslCertificate() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? (ApplicationGatewaySslCertificate)listener.sslCertificate() : null;
    }

    @Override
    public ApplicationGatewayProtocol frontendProtocol() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? (ApplicationGatewayProtocol)listener.protocol() : null;
    }

    @Override
    public String publicIpAddressId() {
        ApplicationGatewayListenerImpl listener = this.listener();
        return listener != null ? listener.publicIpAddressId() : null;
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        return this.getPublicIpAddressAsync().block();
    }

    @Override
    public Mono<PublicIpAddress> getPublicIpAddressAsync() {
        String pipId = this.publicIpAddressId();
        return pipId == null ? Mono.empty() : ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIpAddresses().getByIdAsync(pipId);
    }

    @Override
    public String name() {
        return ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).name();
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleType ruleType() {
        return ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).ruleType();
    }

    @Override
    public ApplicationGatewayBackend backend() {
        SubResource backendRef = ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).backendAddressPool();
        if (backendRef != null) {
            String backendName = ResourceUtils.nameFromResourceId(backendRef.id());
            return ((ApplicationGatewayImpl)this.parent()).backends().get(backendName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl backendHttpConfiguration() {
        SubResource configRef = ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).backendHttpSettings();
        if (configRef != null) {
            String configName = ResourceUtils.nameFromResourceId(configRef.id());
            return (ApplicationGatewayBackendHttpConfigurationImpl)((ApplicationGatewayImpl)this.parent()).backendHttpConfigurations().get(configName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayListenerImpl listener() {
        SubResource listenerRef = ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).httpListener();
        if (listenerRef != null) {
            String listenerName = ResourceUtils.nameFromResourceId(listenerRef.id());
            return (ApplicationGatewayListenerImpl)((ApplicationGatewayImpl)this.parent()).listeners().get(listenerName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayRedirectConfiguration redirectConfiguration() {
        SubResource ref = ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).redirectConfiguration();
        if (ref == null) {
            return null;
        }
        return ((ApplicationGatewayImpl)this.parent()).redirectConfigurations().get(ResourceUtils.nameFromResourceId(ref.id()));
    }

    @Override
    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withRequestRoutingRule(this);
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromPublicFrontend() {
        this.associateWithPublicFrontend = true;
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromPrivateFrontend() {
        this.associateWithPublicFrontend = false;
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromFrontendHttpPort(int portNumber) {
        return this.fromFrontendPort(portNumber, ApplicationGatewayProtocol.HTTP, null);
    }

    public ApplicationGatewayRequestRoutingRuleImpl fromFrontendHttpsPort(int portNumber) {
        return this.fromFrontendPort(portNumber, ApplicationGatewayProtocol.HTTPS, null);
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl toBackendHttpConfiguration(String name) {
        SubResource httpConfigRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/backendHttpSettingsCollection/" + name);
        ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withBackendHttpSettings(httpConfigRef);
        return this;
    }

    private ApplicationGatewayBackendHttpConfigurationImpl ensureBackendHttpConfig() {
        ApplicationGatewayBackendHttpConfigurationImpl config = this.backendHttpConfiguration();
        if (config == null) {
            String name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("bckcfg", 11);
            config = ((ApplicationGatewayImpl)this.parent()).defineBackendHttpConfiguration(name);
            config.attach();
            this.toBackendHttpConfiguration(name);
        }
        return config;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendHttpPort(int portNumber) {
        String name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("backcfg", 12);
        ((ApplicationGatewayImpl)this.parent()).defineBackendHttpConfiguration(name).withPort(portNumber).attach();
        return this.toBackendHttpConfiguration(name);
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withCookieBasedAffinity() {
        ((ApplicationGatewayImpl)this.parent()).updateBackendHttpConfiguration(this.ensureBackendHttpConfig().name()).withCookieBasedAffinity();
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withoutCookieBasedAffinity() {
        ((ApplicationGatewayImpl)this.parent()).updateBackendHttpConfiguration(this.ensureBackendHttpConfig().name()).withoutCookieBasedAffinity();
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl fromListener(String name) {
        SubResource listenerRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/HTTPListeners/" + name);
        ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withHttpListener(listenerRef);
        return this;
    }

    private ApplicationGatewayRequestRoutingRuleImpl fromFrontendPort(int portNumber, ApplicationGatewayProtocol protocol, String name) {
        ApplicationGatewayImpl.CreationState needToCreate;
        ApplicationGatewayListenerImpl listenerByPort = (ApplicationGatewayListenerImpl)((ApplicationGatewayImpl)this.parent()).listenerByPortNumber(portNumber);
        ApplicationGatewayListenerImpl listenerByName = null;
        if (name != null) {
            listenerByName = (ApplicationGatewayListenerImpl)((ApplicationGatewayImpl)this.parent()).listeners().get(name);
        }
        if ((needToCreate = ((ApplicationGatewayImpl)this.parent()).needToCreate(listenerByName, listenerByPort, name)) == ApplicationGatewayImpl.CreationState.NeedToCreate) {
            if (name == null) {
                name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("listener", 13);
            }
            listenerByPort = ((ApplicationGatewayImpl)this.parent()).defineListener(name).withFrontendPort(portNumber);
            if (ApplicationGatewayProtocol.HTTP.equals(protocol)) {
                listenerByPort.withHttp();
            } else if (ApplicationGatewayProtocol.HTTPS.equals(protocol)) {
                listenerByPort.withHttps();
            }
            if (Boolean.TRUE.equals(this.associateWithPublicFrontend)) {
                listenerByPort.withPublicFrontend();
                ((ApplicationGatewayImpl)this.parent()).withNewPublicIpAddress();
            } else if (Boolean.FALSE.equals(this.associateWithPublicFrontend)) {
                listenerByPort.withPrivateFrontend();
            }
            this.associateWithPublicFrontend = null;
            listenerByPort.attach();
            return this.fromListener(listenerByPort.name());
        }
        return null;
    }

    private ApplicationGatewayListenerImpl ensureListener() {
        ApplicationGatewayListenerImpl listener = this.listener();
        if (listener == null) {
            String name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("listener", 13);
            listener = ((ApplicationGatewayImpl)this.parent()).defineListener(name);
            listener.attach();
            this.fromListener(name);
        }
        return listener;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificate(String name) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificate(name);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificateFromKeyVaultSecretId(String keyVaultSecretId) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificateFromKeyVaultSecretId(keyVaultSecretId);
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificateFromPfxFile(File pfxFile) throws IOException {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificateFromPfxFile(pfxFile);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withSslCertificatePassword(String password) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withSslCertificatePassword(password);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withHostname(String hostName) {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withHostname(hostName);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withHostnames(List<String> hostnames) {
        if (CoreUtils.isNullOrEmpty(hostnames)) {
            return this;
        }
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withHostnames((List)hostnames);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withServerNameIndication() {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withServerNameIndication();
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withoutServerNameIndication() {
        ((ApplicationGatewayImpl)this.parent()).updateListener(this.ensureListener().name()).withoutServerNameIndication();
        return this;
    }

    private ApplicationGatewayBackendImpl ensureBackend() {
        ApplicationGatewayBackendImpl backend = (ApplicationGatewayBackendImpl)this.backend();
        if (backend == null) {
            backend = ((ApplicationGatewayImpl)this.parent()).ensureUniqueBackend();
            this.toBackend(backend.name());
        }
        return backend;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl toBackend(String name) {
        ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withBackendAddressPool(((ApplicationGatewayImpl)this.parent()).ensureBackendRef(name));
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendIPAddress(String ipAddress) {
        ((ApplicationGatewayImpl)this.parent()).updateBackend(this.ensureBackend().name()).withIPAddress(ipAddress);
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendIPAddresses(String ... ipAddresses) {
        if (ipAddresses != null) {
            for (String ipAddress : ipAddresses) {
                this.toBackendIPAddress(ipAddress);
            }
        }
        return this;
    }

    public ApplicationGatewayRequestRoutingRuleImpl toBackendFqdn(String fqdn) {
        ((ApplicationGatewayImpl)this.parent()).updateBackend(this.ensureBackend().name()).withFqdn(fqdn);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withRedirectConfiguration(String name) {
        if (name == null) {
            ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withRedirectConfiguration(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/redirectConfigurations/" + name);
            ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withRedirectConfiguration(ref).withBackendAddressPool(null).withBackendHttpSettings(null);
        }
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withoutRedirectConfiguration() {
        ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withRedirectConfiguration(null);
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRule.DefinitionStages.WithAttach<ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate> withUrlPathMap(String urlPathMapName) {
        if (urlPathMapName == null) {
            ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withUrlPathMap(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/urlPathMaps/" + urlPathMapName);
            ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withUrlPathMap(ref);
        }
        return this;
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl withPriority(int priority) {
        ((ApplicationGatewayRequestRoutingRuleInner)this.innerModel()).withPriority(priority);
        return this;
    }
}

