/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class LoadBalancerBackendImpl
extends ChildResourceImpl<BackendAddressPoolInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerBackend,
LoadBalancerBackend.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerBackend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerBackend.Update {
    LoadBalancerBackendImpl(BackendAddressPoolInner inner, LoadBalancerImpl parent) {
        super(inner, parent);
    }

    @Override
    public Map<String, String> backendNicIPConfigurationNames() {
        TreeMap<String, String> ipConfigNames = new TreeMap<String, String>();
        if (((BackendAddressPoolInner)this.innerModel()).backendIpConfigurations() != null) {
            for (NetworkInterfaceIpConfigurationInner inner : ((BackendAddressPoolInner)this.innerModel()).backendIpConfigurations()) {
                String nicId = ResourceUtils.parentResourceIdFromResourceId(inner.id());
                String ipConfigName = ResourceUtils.nameFromResourceId(inner.id());
                ipConfigNames.put(nicId, ipConfigName);
            }
        }
        return Collections.unmodifiableMap(ipConfigNames);
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((BackendAddressPoolInner)this.innerModel()).loadBalancingRules() != null) {
            for (SubResource inner : ((BackendAddressPoolInner)this.innerModel()).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId(inner.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public String name() {
        return ((BackendAddressPoolInner)this.innerModel()).name();
    }

    @Override
    public Set<String> getVirtualMachineIds() {
        HashSet<String> vmIds = new HashSet<String>();
        Map<String, String> nicConfigs = this.backendNicIPConfigurationNames();
        for (String nicId : nicConfigs.keySet()) {
            try {
                NetworkInterface nic = (NetworkInterface)((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).networkInterfaces().getById(nicId);
                if (nic == null || nic.virtualMachineId() == null) continue;
                vmIds.add(nic.virtualMachineId());
            }
            catch (ManagementException | IllegalArgumentException e) {}
        }
        return vmIds;
    }

    @Override
    public LoadBalancerImpl attach() {
        ((LoadBalancerImpl)this.parent()).withBackend(this);
        return (LoadBalancerImpl)this.parent();
    }

    public LoadBalancerBackendImpl withExistingVirtualMachines(HasNetworkInterfaces ... vms) {
        return vms != null ? this.withExistingVirtualMachines(Arrays.asList(vms)) : this;
    }

    public LoadBalancerBackendImpl withExistingVirtualMachines(Collection<HasNetworkInterfaces> vms) {
        if (vms != null) {
            for (HasNetworkInterfaces vm : vms) {
                ((LoadBalancerImpl)this.parent()).withExistingVirtualMachine(vm, this.name());
            }
        }
        return this;
    }
}

