/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.LoadBalancerBackendImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerProbe;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadDistribution;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Subnet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TransportProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class LoadBalancingRuleImpl
extends ChildResourceImpl<LoadBalancingRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancingRule,
LoadBalancingRule.Definition<LoadBalancer.DefinitionStages.WithLBRuleOrNatOrCreate>,
LoadBalancingRule.UpdateDefinition<LoadBalancer.Update>,
LoadBalancingRule.Update {
    LoadBalancingRuleImpl(LoadBalancingRuleInner inner, LoadBalancerImpl parent) {
        super(inner, parent);
    }

    @Override
    public String name() {
        return ((LoadBalancingRuleInner)this.innerModel()).name();
    }

    @Override
    public TransportProtocol protocol() {
        return ((LoadBalancingRuleInner)this.innerModel()).protocol();
    }

    @Override
    public boolean floatingIPEnabled() {
        return ((LoadBalancingRuleInner)this.innerModel()).enableFloatingIp();
    }

    @Override
    public int idleTimeoutInMinutes() {
        return ResourceManagerUtils.toPrimitiveInt(((LoadBalancingRuleInner)this.innerModel()).idleTimeoutInMinutes());
    }

    @Override
    public int frontendPort() {
        return ResourceManagerUtils.toPrimitiveInt(((LoadBalancingRuleInner)this.innerModel()).frontendPort());
    }

    @Override
    public int backendPort() {
        return ResourceManagerUtils.toPrimitiveInt(((LoadBalancingRuleInner)this.innerModel()).backendPort());
    }

    @Override
    public LoadDistribution loadDistribution() {
        return ((LoadBalancingRuleInner)this.innerModel()).loadDistribution();
    }

    @Override
    public LoadBalancerFrontend frontend() {
        SubResource frontendRef = ((LoadBalancingRuleInner)this.innerModel()).frontendIpConfiguration();
        if (frontendRef == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId(frontendRef.id());
        return ((LoadBalancerImpl)this.parent()).frontends().get(frontendName);
    }

    @Override
    public LoadBalancerBackend backend() {
        List<LoadBalancerBackend> backends;
        SubResource backendRef = ((LoadBalancingRuleInner)this.innerModel()).backendAddressPool();
        LoadBalancerBackend backend = this.backendFromSubResource(backendRef);
        if (backend == null && !(backends = this.backends()).isEmpty()) {
            backend = backends.iterator().next();
        }
        return backend;
    }

    @Override
    public LoadBalancerProbe probe() {
        SubResource probeRef = ((LoadBalancingRuleInner)this.innerModel()).probe();
        if (probeRef == null) {
            return null;
        }
        String probeName = ResourceUtils.nameFromResourceId(probeRef.id());
        if (((LoadBalancerImpl)this.parent()).httpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).httpProbes().get(probeName);
        }
        if (((LoadBalancerImpl)this.parent()).tcpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).tcpProbes().get(probeName);
        }
        return null;
    }

    @Override
    public List<LoadBalancerBackend> backends() {
        ArrayList<LoadBalancerBackend> backends = new ArrayList<LoadBalancerBackend>();
        if (!CoreUtils.isNullOrEmpty(((LoadBalancingRuleInner)this.innerModel()).backendAddressPools())) {
            for (SubResource backendRef : ((LoadBalancingRuleInner)this.innerModel()).backendAddressPools()) {
                backends.add(this.backendFromSubResource(backendRef));
            }
        }
        return Collections.unmodifiableList(backends);
    }

    private LoadBalancerBackend backendFromSubResource(SubResource backendRef) {
        if (backendRef == null) {
            return null;
        }
        String backendName = ResourceUtils.nameFromResourceId(backendRef.id());
        return ((LoadBalancerImpl)this.parent()).backends().get(backendName);
    }

    @Override
    public LoadBalancingRuleImpl fromExistingPublicIPAddress(PublicIpAddress publicIPAddress) {
        return publicIPAddress != null ? this.fromExistingPublicIPAddress(publicIPAddress.id()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingPublicIPAddress(String resourceId) {
        return null != resourceId ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePublicFrontendWithPip(resourceId).name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress(String leafDnsLabel) {
        String frontendName = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress(Creatable<PublicIpAddress> pipDefinition) {
        String frontendName = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(pipDefinition, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress() {
        String dnsLabel = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        return this.fromNewPublicIPAddress(dnsLabel);
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(String networkResourceId, String subnetName) {
        return null != networkResourceId && null != subnetName ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePrivateFrontendWithSubnet(networkResourceId, subnetName).name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(Network network, String subnetName) {
        return null != network && null != subnetName ? this.fromExistingSubnet(network.id(), subnetName) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(Subnet subnet) {
        return null != subnet ? this.fromExistingSubnet(((Network)subnet.parent()).id(), subnet.name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((LoadBalancingRuleInner)this.innerModel()).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIP(boolean enable) {
        ((LoadBalancingRuleInner)this.innerModel()).withEnableFloatingIp(enable);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIPEnabled() {
        return this.withFloatingIP(true);
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIPDisabled() {
        return this.withFloatingIP(false);
    }

    @Override
    public LoadBalancingRuleImpl withProtocol(TransportProtocol protocol) {
        ((LoadBalancingRuleInner)this.innerModel()).withProtocol(protocol);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl fromFrontendPort(int port) {
        ((LoadBalancingRuleInner)this.innerModel()).withFrontendPort(port);
        if (((LoadBalancingRuleInner)this.innerModel()).backendPort() == null || ((LoadBalancingRuleInner)this.innerModel()).backendPort() == 0) {
            ((LoadBalancingRuleInner)this.innerModel()).withBackendPort(port);
        }
        return this;
    }

    @Override
    public LoadBalancingRuleImpl toBackendPort(int port) {
        ((LoadBalancingRuleInner)this.innerModel()).withBackendPort(port);
        return this;
    }

    public LoadBalancingRuleImpl toExistingVirtualMachines(HasNetworkInterfaces ... vms) {
        return vms != null ? this.toExistingVirtualMachines(Arrays.asList(vms)) : this;
    }

    public LoadBalancingRuleImpl toExistingVirtualMachines(Collection<HasNetworkInterfaces> vms) {
        if (vms != null) {
            LoadBalancerBackend.DefinitionStages.WithAttach backend = ((LoadBalancerImpl)this.parent()).ensureUniqueBackend().withExistingVirtualMachines((Collection)vms);
            this.toBackend(((LoadBalancerBackendImpl)backend).name());
        }
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withLoadDistribution(LoadDistribution loadDistribution) {
        ((LoadBalancingRuleInner)this.innerModel()).withLoadDistribution(loadDistribution);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl fromFrontend(String frontendName) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(frontendName);
        if (frontendRef != null) {
            ((LoadBalancingRuleInner)this.innerModel()).withFrontendIpConfiguration(frontendRef);
        }
        return this;
    }

    public LoadBalancingRuleImpl toBackend(String backendName) {
        ((LoadBalancerImpl)this.parent()).defineBackend(backendName).attach();
        SubResource backendRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/backendAddressPools/" + backendName);
        ((LoadBalancingRuleInner)this.innerModel()).withBackendAddressPool(backendRef);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withProbe(String name) {
        SubResource probeRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/probes/" + name);
        ((LoadBalancingRuleInner)this.innerModel()).withProbe(probeRef);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withoutProbe() {
        ((LoadBalancingRuleInner)this.innerModel()).withProbe(null);
        return this;
    }

    @Override
    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withLoadBalancingRule(this);
    }
}

