/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkSecurityGroupImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityRuleDirection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class NetworkSecurityRuleImpl
extends ChildResourceImpl<SecurityRuleInner, NetworkSecurityGroupImpl, NetworkSecurityGroup>
implements NetworkSecurityRule,
NetworkSecurityRule.Definition<NetworkSecurityGroup.DefinitionStages.WithCreate>,
NetworkSecurityRule.UpdateDefinition<NetworkSecurityGroup.Update>,
NetworkSecurityRule.Update {
    private Map<String, ApplicationSecurityGroupInner> sourceAsgs = new HashMap<String, ApplicationSecurityGroupInner>();
    private Map<String, ApplicationSecurityGroupInner> destinationAsgs = new HashMap<String, ApplicationSecurityGroupInner>();
    private final ClientLogger logger = new ClientLogger(this.getClass());

    NetworkSecurityRuleImpl(SecurityRuleInner inner, NetworkSecurityGroupImpl parent) {
        super(inner, parent);
        if (inner.sourceApplicationSecurityGroups() != null) {
            for (ApplicationSecurityGroupInner asg : inner.sourceApplicationSecurityGroups()) {
                this.sourceAsgs.put(asg.id(), asg);
            }
        }
        if (inner.destinationApplicationSecurityGroups() != null) {
            for (ApplicationSecurityGroupInner asg : inner.destinationApplicationSecurityGroups()) {
                this.destinationAsgs.put(asg.id(), asg);
            }
        }
    }

    @Override
    public String name() {
        return ((SecurityRuleInner)this.innerModel()).name();
    }

    @Override
    public SecurityRuleDirection direction() {
        return ((SecurityRuleInner)this.innerModel()).direction();
    }

    @Override
    public SecurityRuleProtocol protocol() {
        return ((SecurityRuleInner)this.innerModel()).protocol();
    }

    @Override
    public SecurityRuleAccess access() {
        return ((SecurityRuleInner)this.innerModel()).access();
    }

    @Override
    public String sourceAddressPrefix() {
        return ((SecurityRuleInner)this.innerModel()).sourceAddressPrefix();
    }

    @Override
    public List<String> sourceAddressPrefixes() {
        return Collections.unmodifiableList(((SecurityRuleInner)this.innerModel()).sourceAddressPrefixes());
    }

    @Override
    public String sourcePortRange() {
        return ((SecurityRuleInner)this.innerModel()).sourcePortRange();
    }

    @Override
    public List<String> sourcePortRanges() {
        return Collections.unmodifiableList(((SecurityRuleInner)this.innerModel()).sourcePortRanges());
    }

    @Override
    public String destinationAddressPrefix() {
        return ((SecurityRuleInner)this.innerModel()).destinationAddressPrefix();
    }

    @Override
    public List<String> destinationAddressPrefixes() {
        return Collections.unmodifiableList(((SecurityRuleInner)this.innerModel()).destinationAddressPrefixes());
    }

    @Override
    public String destinationPortRange() {
        return ((SecurityRuleInner)this.innerModel()).destinationPortRange();
    }

    @Override
    public List<String> destinationPortRanges() {
        return Collections.unmodifiableList(((SecurityRuleInner)this.innerModel()).destinationPortRanges());
    }

    @Override
    public int priority() {
        return ResourceManagerUtils.toPrimitiveInt(((SecurityRuleInner)this.innerModel()).priority());
    }

    @Override
    public Set<String> sourceApplicationSecurityGroupIds() {
        return Collections.unmodifiableSet(this.sourceAsgs.keySet());
    }

    @Override
    public Set<String> destinationApplicationSecurityGroupIds() {
        return Collections.unmodifiableSet(this.destinationAsgs.keySet());
    }

    @Override
    public NetworkSecurityRuleImpl allowInbound() {
        return this.withDirection(SecurityRuleDirection.INBOUND).withAccess(SecurityRuleAccess.ALLOW);
    }

    @Override
    public NetworkSecurityRuleImpl allowOutbound() {
        return this.withDirection(SecurityRuleDirection.OUTBOUND).withAccess(SecurityRuleAccess.ALLOW);
    }

    @Override
    public NetworkSecurityRuleImpl denyInbound() {
        return this.withDirection(SecurityRuleDirection.INBOUND).withAccess(SecurityRuleAccess.DENY);
    }

    @Override
    public NetworkSecurityRuleImpl denyOutbound() {
        return this.withDirection(SecurityRuleDirection.OUTBOUND).withAccess(SecurityRuleAccess.DENY);
    }

    @Override
    public NetworkSecurityRuleImpl withProtocol(SecurityRuleProtocol protocol) {
        ((SecurityRuleInner)this.innerModel()).withProtocol(protocol);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withAnyProtocol() {
        return this.withProtocol(SecurityRuleProtocol.ASTERISK);
    }

    @Override
    public NetworkSecurityRuleImpl fromAddress(String cidr) {
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefix(cidr);
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefixes(null);
        ((SecurityRuleInner)this.innerModel()).withSourceApplicationSecurityGroups(null);
        if (this.sourceAsgs != null) {
            this.sourceAsgs.clear();
        }
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAnyAddress() {
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefix("*");
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefixes(null);
        ((SecurityRuleInner)this.innerModel()).withSourceApplicationSecurityGroups(null);
        if (this.sourceAsgs != null) {
            this.sourceAsgs.clear();
        }
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAddresses(String ... addresses) {
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefixes(Arrays.asList(addresses));
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefix(null);
        ((SecurityRuleInner)this.innerModel()).withSourceApplicationSecurityGroups(null);
        if (this.sourceAsgs != null) {
            this.sourceAsgs.clear();
        }
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPort(int port) {
        ((SecurityRuleInner)this.innerModel()).withSourcePortRange(String.valueOf(port));
        ((SecurityRuleInner)this.innerModel()).withSourcePortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAnyPort() {
        ((SecurityRuleInner)this.innerModel()).withSourcePortRange("*");
        ((SecurityRuleInner)this.innerModel()).withSourcePortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPortRange(int from, int to) {
        ((SecurityRuleInner)this.innerModel()).withSourcePortRange(String.valueOf(from) + "-" + String.valueOf(to));
        ((SecurityRuleInner)this.innerModel()).withSourcePortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPortRanges(String ... ranges) {
        ((SecurityRuleInner)this.innerModel()).withSourcePortRanges(Arrays.asList(ranges));
        ((SecurityRuleInner)this.innerModel()).withSourcePortRange(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAddress(String cidr) {
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefix(cidr);
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefixes(null);
        ((SecurityRuleInner)this.innerModel()).withDestinationApplicationSecurityGroups(null);
        if (this.destinationAsgs != null) {
            this.destinationAsgs.clear();
        }
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAddresses(String ... addresses) {
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefixes(Arrays.asList(addresses));
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefix(null);
        ((SecurityRuleInner)this.innerModel()).withDestinationApplicationSecurityGroups(null);
        if (this.destinationAsgs != null) {
            this.destinationAsgs.clear();
        }
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAnyAddress() {
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefix("*");
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefixes(null);
        ((SecurityRuleInner)this.innerModel()).withDestinationApplicationSecurityGroups(null);
        if (this.destinationAsgs != null) {
            this.destinationAsgs.clear();
        }
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPort(int port) {
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRange(String.valueOf(port));
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAnyPort() {
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRange("*");
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPortRange(int from, int to) {
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRange(String.valueOf(from) + "-" + String.valueOf(to));
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPortRanges(String ... ranges) {
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRanges(Arrays.asList(ranges));
        ((SecurityRuleInner)this.innerModel()).withDestinationPortRange(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withPriority(int priority) {
        if (priority < 100 || priority > 4096) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("The priority number of a network security rule must be between 100 and 4096."));
        }
        ((SecurityRuleInner)this.innerModel()).withPriority(priority);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withDescription(String description) {
        ((SecurityRuleInner)this.innerModel()).withDescription(description);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withSourceApplicationSecurityGroup(String id) {
        this.sourceAsgs.put(id, new ApplicationSecurityGroupInner().withId(id));
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefix(null);
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefixes(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withoutSourceApplicationSecurityGroup(String id) {
        this.sourceAsgs.remove(id);
        return this;
    }

    public NetworkSecurityRuleImpl withSourceApplicationSecurityGroup(String ... ids) {
        this.sourceAsgs = Arrays.stream(ids).collect(Collectors.toMap(Function.identity(), id -> new ApplicationSecurityGroupInner().withId((String)id)));
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefix(null);
        ((SecurityRuleInner)this.innerModel()).withSourceAddressPrefixes(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withDestinationApplicationSecurityGroup(String id) {
        this.destinationAsgs.put(id, new ApplicationSecurityGroupInner().withId(id));
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefix(null);
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefixes(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withoutDestinationApplicationSecurityGroup(String id) {
        this.destinationAsgs.remove(id);
        return this;
    }

    public NetworkSecurityRuleImpl withDestinationApplicationSecurityGroup(String ... ids) {
        this.destinationAsgs = Arrays.stream(ids).collect(Collectors.toMap(Function.identity(), id -> new ApplicationSecurityGroupInner().withId((String)id)));
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefix(null);
        ((SecurityRuleInner)this.innerModel()).withDestinationAddressPrefixes(null);
        return this;
    }

    private NetworkSecurityRuleImpl withDirection(SecurityRuleDirection direction) {
        ((SecurityRuleInner)this.innerModel()).withDirection(direction);
        return this;
    }

    private NetworkSecurityRuleImpl withAccess(SecurityRuleAccess permission) {
        ((SecurityRuleInner)this.innerModel()).withAccess(permission);
        return this;
    }

    @Override
    public NetworkSecurityGroupImpl attach() {
        return this.parent().withRule(this);
    }

    @Override
    public NetworkSecurityGroupImpl parent() {
        ((SecurityRuleInner)this.innerModel()).withSourceApplicationSecurityGroups(new ArrayList<ApplicationSecurityGroupInner>(this.sourceAsgs.values()));
        ((SecurityRuleInner)this.innerModel()).withDestinationApplicationSecurityGroups(new ArrayList<ApplicationSecurityGroupInner>(this.destinationAsgs.values()));
        return (NetworkSecurityGroupImpl)super.parent();
    }

    @Override
    public String description() {
        return ((SecurityRuleInner)this.innerModel()).description();
    }
}

