/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.Utils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerInboundNatRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfigurationBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Subnet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

abstract class NicIpConfigurationBaseImpl<ParentImplT extends ParentT, ParentT extends HasManager<NetworkManager>>
extends ChildResourceImpl<NetworkInterfaceIpConfigurationInner, ParentImplT, ParentT>
implements NicIpConfigurationBase {
    private final NetworkManager networkManager;

    protected NicIpConfigurationBaseImpl(NetworkInterfaceIpConfigurationInner inner, ParentImplT parent, NetworkManager networkManager) {
        super(inner, parent);
        this.networkManager = networkManager;
    }

    @Override
    public String name() {
        return ((NetworkInterfaceIpConfigurationInner)this.innerModel()).name();
    }

    @Override
    public boolean isPrimary() {
        return ResourceManagerUtils.toPrimitiveBoolean(((NetworkInterfaceIpConfigurationInner)this.innerModel()).primary());
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        Network network = this.getNetwork();
        if (network == null) {
            return null;
        }
        String subnetName = this.subnetName();
        if (subnetName == null) {
            return null;
        }
        Subnet subnet = network.subnets().get(subnetName);
        if (subnet == null) {
            return null;
        }
        return subnet.getNetworkSecurityGroup();
    }

    @Override
    public String privateIpAddress() {
        return ((NetworkInterfaceIpConfigurationInner)this.innerModel()).privateIpAddress();
    }

    @Override
    public IpAllocationMethod privateIpAllocationMethod() {
        return ((NetworkInterfaceIpConfigurationInner)this.innerModel()).privateIpAllocationMethod();
    }

    @Override
    public IpVersion privateIpAddressVersion() {
        return ((NetworkInterfaceIpConfigurationInner)this.innerModel()).privateIpAddressVersion();
    }

    @Override
    public String networkId() {
        SubnetInner subnetRef = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).subnet();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.parentResourceIdFromResourceId(subnetRef.id());
    }

    @Override
    public Network getNetwork() {
        String id = this.networkId();
        if (id == null) {
            return null;
        }
        return (Network)this.networkManager.networks().getById(id);
    }

    @Override
    public String subnetName() {
        SubnetInner subnetRef = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).subnet();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId(subnetRef.id());
    }

    @Override
    public Collection<ApplicationGatewayBackend> listAssociatedApplicationGatewayBackends() {
        return Utils.listAssociatedApplicationGatewayBackends((NetworkManager)((HasManager)this.parent()).manager(), ((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationGatewayBackendAddressPools());
    }

    @Override
    public List<LoadBalancerBackend> listAssociatedLoadBalancerBackends() {
        List<BackendAddressPoolInner> backendRefs = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).loadBalancerBackendAddressPools();
        if (backendRefs == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
        ArrayList<LoadBalancerBackend> backends = new ArrayList<LoadBalancerBackend>();
        for (BackendAddressPoolInner backendRef : backendRefs) {
            String loadBalancerId = ResourceUtils.parentResourceIdFromResourceId(backendRef.id());
            LoadBalancer loadBalancer = (LoadBalancer)loadBalancers.get(loadBalancerId.toLowerCase(Locale.ROOT));
            if (loadBalancer == null) {
                loadBalancer = (LoadBalancer)this.networkManager.loadBalancers().getById(loadBalancerId);
                loadBalancers.put(loadBalancerId.toLowerCase(Locale.ROOT), loadBalancer);
            }
            String backendName = ResourceUtils.nameFromResourceId(backendRef.id());
            backends.add(loadBalancer.backends().get(backendName));
        }
        return Collections.unmodifiableList(backends);
    }

    @Override
    public List<LoadBalancerInboundNatRule> listAssociatedLoadBalancerInboundNatRules() {
        List<InboundNatRuleInner> inboundNatPoolRefs = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).loadBalancerInboundNatRules();
        if (inboundNatPoolRefs == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
        ArrayList<LoadBalancerInboundNatRule> rules = new ArrayList<LoadBalancerInboundNatRule>();
        for (InboundNatRuleInner ref : inboundNatPoolRefs) {
            String loadBalancerId = ResourceUtils.parentResourceIdFromResourceId(ref.id());
            LoadBalancer loadBalancer = (LoadBalancer)loadBalancers.get(loadBalancerId.toLowerCase(Locale.ROOT));
            if (loadBalancer == null) {
                loadBalancer = (LoadBalancer)this.networkManager.loadBalancers().getById(loadBalancerId);
                loadBalancers.put(loadBalancerId.toLowerCase(Locale.ROOT), loadBalancer);
            }
            String ruleName = ResourceUtils.nameFromResourceId(ref.id());
            rules.add(loadBalancer.inboundNatRules().get(ruleName));
        }
        return Collections.unmodifiableList(rules);
    }

    @Override
    public List<ApplicationSecurityGroup> listAssociatedApplicationSecurityGroups() {
        if (CoreUtils.isNullOrEmpty(((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationSecurityGroups())) {
            return Collections.emptyList();
        }
        List applicationSecurityGroups = Flux.fromStream(((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationSecurityGroups().stream().map(ApplicationSecurityGroupInner::id)).flatMapSequential(id -> this.networkManager.applicationSecurityGroups().getByIdAsync((String)id)).collectList().block();
        return applicationSecurityGroups == null ? Collections.emptyList() : Collections.unmodifiableList(applicationSecurityGroups);
    }
}

