/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.LoadBalancerInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualNetworkInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkInterfaceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NicIpConfigurationBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddressPool;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.DeleteOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class NicIpConfigurationImpl
extends NicIpConfigurationBaseImpl<NetworkInterfaceImpl, NetworkInterface>
implements NicIpConfiguration,
NicIpConfiguration.Definition<NetworkInterface.DefinitionStages.WithCreate>,
NicIpConfiguration.UpdateDefinition<NetworkInterface.Update>,
NicIpConfiguration.Update {
    private final NetworkManager networkManager;
    private final boolean isInCreateMode;
    private String creatableVirtualNetworkKey;
    private String creatablePublicIPKey;
    private Network existingVirtualNetworkToAssociate;
    private String existingPublicIPAddressIdToAssociate;
    private String subnetToAssociate;
    private boolean removePrimaryPublicIPAssociation;
    private final ClientLogger logger = new ClientLogger(this.getClass());

    protected NicIpConfigurationImpl(NetworkInterfaceIpConfigurationInner inner, NetworkInterfaceImpl parent, NetworkManager networkManager, boolean isInCreateModel) {
        super(inner, parent, networkManager);
        this.isInCreateMode = isInCreateModel;
        this.networkManager = networkManager;
    }

    protected static NicIpConfigurationImpl prepareNicIPConfiguration(String name, NetworkInterfaceImpl parent, NetworkManager networkManager) {
        NetworkInterfaceIpConfigurationInner ipConfigurationInner = new NetworkInterfaceIpConfigurationInner();
        ipConfigurationInner.withName(name);
        return new NicIpConfigurationImpl(ipConfigurationInner, parent, networkManager, true);
    }

    @Override
    public String publicIpAddressId() {
        if (((NetworkInterfaceIpConfigurationInner)this.innerModel()).publicIpAddress() == null) {
            return null;
        }
        return ((NetworkInterfaceIpConfigurationInner)this.innerModel()).publicIpAddress().id();
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        return this.getPublicIpAddressAsync().block();
    }

    @Override
    public Mono<PublicIpAddress> getPublicIpAddressAsync() {
        String pipId = this.publicIpAddressId();
        return pipId == null ? Mono.empty() : this.networkManager.publicIpAddresses().getByIdAsync(pipId);
    }

    @Override
    public NetworkInterfaceImpl attach() {
        return ((NetworkInterfaceImpl)this.parent()).withIPConfiguration(this);
    }

    public NicIpConfigurationImpl withNewNetwork(Creatable<Network> creatable) {
        this.creatableVirtualNetworkKey = creatable.key();
        ((NetworkInterfaceImpl)this.parent()).addToCreatableDependencies(creatable);
        return this;
    }

    public NicIpConfigurationImpl withNewNetwork(String name, String addressSpaceCidr) {
        Network.DefinitionStages.WithGroup definitionWithGroup = (Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.networkManager.networks().define(name)).withRegion(((NetworkInterfaceImpl)this.parent()).regionName());
        Network.DefinitionStages.WithCreate definitionAfterGroup = ((NetworkInterfaceImpl)this.parent()).newGroup() != null ? (Network.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(((NetworkInterfaceImpl)this.parent()).newGroup()) : (Network.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(((NetworkInterfaceImpl)this.parent()).resourceGroupName());
        return this.withNewNetwork((Creatable)definitionAfterGroup.withAddressSpace(addressSpaceCidr));
    }

    public NicIpConfigurationImpl withNewNetwork(String addressSpaceCidr) {
        return this.withNewNetwork(((NetworkInterfaceImpl)this.parent()).namer.getRandomName("vnet", 20), addressSpaceCidr);
    }

    public NicIpConfigurationImpl withExistingNetwork(Network network) {
        this.existingVirtualNetworkToAssociate = network;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withPrivateIpAddressDynamic() {
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withPrivateIpAllocationMethod(IpAllocationMethod.DYNAMIC);
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withPrivateIpAddress(null);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withPrivateIpAddressStatic(String staticPrivateIPAddress) {
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withPrivateIpAllocationMethod(IpAllocationMethod.STATIC);
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withPrivateIpAddress(staticPrivateIPAddress);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withNewPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        if (this.creatablePublicIPKey == null) {
            this.creatablePublicIPKey = creatable.key();
            ((NetworkInterfaceImpl)this.parent()).addToCreatableDependencies(creatable);
        }
        return this;
    }

    @Override
    public NicIpConfigurationImpl withNewPublicIpAddress() {
        String name = ((NetworkInterfaceImpl)this.parent()).namer.getRandomName("pip", 15);
        return this.withNewPublicIpAddress((Creatable)this.prepareCreatablePublicIP(name, name));
    }

    @Override
    public NicIpConfigurationImpl withNewPublicIpAddress(String leafDnsLabel) {
        return this.withNewPublicIpAddress((Creatable)this.prepareCreatablePublicIP(((NetworkInterfaceImpl)this.parent()).namer.getRandomName("pip", 15), leafDnsLabel));
    }

    @Override
    public NicIpConfigurationImpl withExistingPublicIpAddress(PublicIpAddress publicIpAddress) {
        return this.withExistingPublicIpAddress(publicIpAddress.id());
    }

    @Override
    public NicIpConfigurationImpl withExistingPublicIpAddress(String resourceId) {
        this.existingPublicIPAddressIdToAssociate = resourceId;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withoutPublicIpAddress() {
        this.removePrimaryPublicIPAssociation = true;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withSubnet(String name) {
        this.subnetToAssociate = name;
        return this;
    }

    @Override
    public NicIpConfigurationImpl withExistingLoadBalancerBackend(LoadBalancer loadBalancer, String backendName) {
        if (loadBalancer != null) {
            for (BackendAddressPoolInner pool : ((LoadBalancerInner)loadBalancer.innerModel()).backendAddressPools()) {
                if (!pool.name().equalsIgnoreCase(backendName)) continue;
                this.ensureLoadBalancerBackendAddressPools().add(pool);
                return this;
            }
        }
        return null;
    }

    @Override
    public NicIpConfigurationImpl withExistingApplicationGatewayBackend(ApplicationGateway appGateway, String backendName) {
        if (appGateway != null) {
            for (ApplicationGatewayBackendAddressPool pool : ((ApplicationGatewayInner)appGateway.innerModel()).backendAddressPools()) {
                if (!pool.name().equalsIgnoreCase(backendName)) continue;
                this.ensureAppGatewayBackendAddressPools().add(pool);
                return this;
            }
        }
        return null;
    }

    @Override
    public NicIpConfigurationImpl withExistingLoadBalancerInboundNatRule(LoadBalancer loadBalancer, String inboundNatRuleName) {
        if (loadBalancer != null) {
            for (InboundNatRuleInner rule : ((LoadBalancerInner)loadBalancer.innerModel()).inboundNatRules()) {
                if (!rule.name().equalsIgnoreCase(inboundNatRuleName)) continue;
                this.ensureInboundNatRules().add(rule);
                return this;
            }
        }
        return null;
    }

    private List<ApplicationGatewayBackendAddressPool> ensureAppGatewayBackendAddressPools() {
        List<ApplicationGatewayBackendAddressPool> poolRefs = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationGatewayBackendAddressPools();
        if (poolRefs == null) {
            poolRefs = new ArrayList<ApplicationGatewayBackendAddressPool>();
            ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withApplicationGatewayBackendAddressPools(poolRefs);
        }
        return poolRefs;
    }

    private List<BackendAddressPoolInner> ensureLoadBalancerBackendAddressPools() {
        List<BackendAddressPoolInner> poolRefs = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).loadBalancerBackendAddressPools();
        if (poolRefs == null) {
            poolRefs = new ArrayList<BackendAddressPoolInner>();
            ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withLoadBalancerBackendAddressPools(poolRefs);
        }
        return poolRefs;
    }

    private List<InboundNatRuleInner> ensureInboundNatRules() {
        List<InboundNatRuleInner> natRefs = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).loadBalancerInboundNatRules();
        if (natRefs == null) {
            natRefs = new ArrayList<InboundNatRuleInner>();
            ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withLoadBalancerInboundNatRules(natRefs);
        }
        return natRefs;
    }

    protected static void ensureConfigurations(Collection<NicIpConfiguration> nicIPConfigurations, Map<String, DeleteOptions> specifiedIpConfigNames) {
        for (NicIpConfiguration nicIPConfiguration : nicIPConfigurations) {
            NicIpConfigurationImpl config = (NicIpConfigurationImpl)nicIPConfiguration;
            ((NetworkInterfaceIpConfigurationInner)config.innerModel()).withSubnet(config.subnetToAssociate());
            ((NetworkInterfaceIpConfigurationInner)config.innerModel()).withPublicIpAddress(config.publicIPToAssociate(specifiedIpConfigNames.getOrDefault(config.name(), null)));
        }
    }

    private Creatable<PublicIpAddress> prepareCreatablePublicIP(String name, String leafDnsLabel) {
        PublicIpAddress.DefinitionStages.WithGroup definitionWithGroup = (PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.networkManager.publicIpAddresses().define(name)).withRegion(((NetworkInterfaceImpl)this.parent()).regionName());
        PublicIpAddress.DefinitionStages.WithCreate definitionAfterGroup = ((NetworkInterfaceImpl)this.parent()).newGroup() != null ? (PublicIpAddress.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(((NetworkInterfaceImpl)this.parent()).newGroup()) : (PublicIpAddress.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(((NetworkInterfaceImpl)this.parent()).resourceGroupName());
        return definitionAfterGroup.withLeafDomainLabel(leafDnsLabel);
    }

    private SubnetInner subnetToAssociate() {
        SubnetInner subnetInner = new SubnetInner();
        if (this.isInCreateMode) {
            if (this.creatableVirtualNetworkKey != null) {
                Network network = (Network)((NetworkInterfaceImpl)this.parent()).createdDependencyResource(this.creatableVirtualNetworkKey);
                subnetInner.withId(((VirtualNetworkInner)network.innerModel()).subnets().get(0).id());
                return subnetInner;
            }
            for (SubnetInner subnet : ((VirtualNetworkInner)this.existingVirtualNetworkToAssociate.innerModel()).subnets()) {
                if (!subnet.name().equalsIgnoreCase(this.subnetToAssociate)) continue;
                subnetInner.withId(subnet.id());
                return subnetInner;
            }
            throw this.logger.logExceptionAsError(new RuntimeException("A subnet with name '" + this.subnetToAssociate + "' not found under the network '" + this.existingVirtualNetworkToAssociate.name() + "'"));
        }
        if (this.subnetToAssociate != null) {
            int idx = ((NetworkInterfaceIpConfigurationInner)this.innerModel()).subnet().id().lastIndexOf(47);
            subnetInner.withId(((NetworkInterfaceIpConfigurationInner)this.innerModel()).subnet().id().substring(0, idx + 1) + this.subnetToAssociate);
        } else {
            subnetInner.withId(((NetworkInterfaceIpConfigurationInner)this.innerModel()).subnet().id());
        }
        return subnetInner;
    }

    private PublicIpAddressInner publicIPToAssociate(DeleteOptions deleteOptions) {
        String pipId = null;
        if (this.removePrimaryPublicIPAssociation) {
            return null;
        }
        if (this.creatablePublicIPKey != null) {
            pipId = ((PublicIpAddress)((NetworkInterfaceImpl)this.parent()).createdDependencyResource(this.creatablePublicIPKey)).id();
        } else if (this.existingPublicIPAddressIdToAssociate != null) {
            pipId = this.existingPublicIPAddressIdToAssociate;
        }
        if (pipId != null) {
            if (Objects.nonNull(deleteOptions)) {
                return new PublicIpAddressInner().withId(pipId).withDeleteOption(deleteOptions);
            }
            return new PublicIpAddressInner().withId(pipId);
        }
        if (!this.isInCreateMode) {
            if (Objects.nonNull(((NetworkInterfaceIpConfigurationInner)this.innerModel()).publicIpAddress()) && Objects.nonNull(deleteOptions)) {
                return ((NetworkInterfaceIpConfigurationInner)this.innerModel()).publicIpAddress().withDeleteOption(deleteOptions);
            }
            return ((NetworkInterfaceIpConfigurationInner)this.innerModel()).publicIpAddress();
        }
        return null;
    }

    @Override
    public NicIpConfigurationImpl withPrivateIpVersion(IpVersion ipVersion) {
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withPrivateIpAddressVersion(ipVersion);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withoutApplicationGatewayBackends() {
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withApplicationGatewayBackendAddressPools(null);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withoutLoadBalancerBackends() {
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withLoadBalancerBackendAddressPools(null);
        return this;
    }

    @Override
    public NicIpConfigurationImpl withoutLoadBalancerInboundNatRules() {
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withLoadBalancerInboundNatRules(null);
        return this;
    }

    NicIpConfigurationImpl withExistingApplicationSecurityGroup(ApplicationSecurityGroup applicationSecurityGroup) {
        this.withExistingApplicationSecurityGroup((ApplicationSecurityGroupInner)applicationSecurityGroup.innerModel());
        return this;
    }

    NicIpConfigurationImpl withExistingApplicationSecurityGroup(ApplicationSecurityGroupInner inner) {
        if (((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationSecurityGroups() == null) {
            ((NetworkInterfaceIpConfigurationInner)this.innerModel()).withApplicationSecurityGroups(new ArrayList<ApplicationSecurityGroupInner>());
        }
        ((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationSecurityGroups().add(inner);
        return this;
    }

    NicIpConfigurationImpl withoutApplicationSecurityGroup(String name) {
        if (((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationSecurityGroups() != null) {
            ((NetworkInterfaceIpConfigurationInner)this.innerModel()).applicationSecurityGroups().removeIf(asg -> {
                String asgName = asg.name() == null ? ResourceUtils.nameFromResourceId(asg.id()) : asg.name();
                return Objects.equals(name, asgName);
            });
        }
        return this;
    }

    @Override
    public NicIpConfigurationImpl withPublicIPAddressDeleteOptions(DeleteOptions deleteOptions) {
        ((NetworkInterfaceImpl)this.parent()).ensureDeleteOptions(deleteOptions, ((NetworkInterfaceIpConfigurationInner)this.innerModel()).name());
        return this;
    }
}

