/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AppliableWithTags;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpTag;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerPublicFrontend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIPSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TagsObject;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class PublicIpAddressImpl
extends GroupableResourceImpl<PublicIpAddress, PublicIpAddressInner, PublicIpAddressImpl, NetworkManager>
implements PublicIpAddress,
PublicIpAddress.Definition,
PublicIpAddress.Update,
AppliableWithTags<PublicIpAddress> {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    PublicIpAddressImpl(String name, PublicIpAddressInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    protected Mono<PublicIpAddressInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public PublicIpAddressImpl withIdleTimeoutInMinutes(int minutes) {
        ((PublicIpAddressInner)this.innerModel()).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public PublicIpAddressImpl withStaticIP() {
        ((PublicIpAddressInner)this.innerModel()).withPublicIpAllocationMethod(IpAllocationMethod.STATIC);
        return this;
    }

    @Override
    public PublicIpAddressImpl withDynamicIP() {
        ((PublicIpAddressInner)this.innerModel()).withPublicIpAllocationMethod(IpAllocationMethod.DYNAMIC);
        return this;
    }

    @Override
    public PublicIpAddressImpl withLeafDomainLabel(String dnsName) {
        if (((PublicIpAddressInner)this.innerModel()).dnsSettings() == null) {
            ((PublicIpAddressInner)this.innerModel()).withDnsSettings(new PublicIpAddressDnsSettings());
        }
        ((PublicIpAddressInner)this.innerModel()).dnsSettings().withDomainNameLabel(dnsName == null ? null : dnsName.toLowerCase(Locale.ROOT));
        return this;
    }

    @Override
    public PublicIpAddressImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((PublicIpAddressInner)this.innerModel()).zones() == null) {
            ((PublicIpAddressInner)this.innerModel()).withZones(new ArrayList<String>());
        }
        ((PublicIpAddressInner)this.innerModel()).zones().add(zoneId.toString());
        return this;
    }

    @Override
    public PublicIpAddressImpl withSku(PublicIPSkuType skuType) {
        ((PublicIpAddressInner)this.innerModel()).withSku(skuType.sku());
        return this;
    }

    @Override
    public PublicIpAddressImpl withoutLeafDomainLabel() {
        ((PublicIpAddressInner)this.innerModel()).withDnsSettings(null);
        return this;
    }

    @Override
    public PublicIpAddressImpl withReverseFqdn(String reverseFqdn) {
        if (((PublicIpAddressInner)this.innerModel()).dnsSettings() == null) {
            ((PublicIpAddressInner)this.innerModel()).withDnsSettings(new PublicIpAddressDnsSettings());
        }
        ((PublicIpAddressInner)this.innerModel()).dnsSettings().withReverseFqdn(reverseFqdn != null ? reverseFqdn.toLowerCase(Locale.ROOT) : null);
        return this;
    }

    @Override
    public PublicIpAddressImpl withoutReverseFqdn() {
        return this.withReverseFqdn(null);
    }

    @Override
    public int idleTimeoutInMinutes() {
        return ResourceManagerUtils.toPrimitiveInt(((PublicIpAddressInner)this.innerModel()).idleTimeoutInMinutes());
    }

    @Override
    public IpAllocationMethod ipAllocationMethod() {
        return ((PublicIpAddressInner)this.innerModel()).publicIpAllocationMethod();
    }

    @Override
    public IpVersion version() {
        return ((PublicIpAddressInner)this.innerModel()).publicIpAddressVersion();
    }

    @Override
    public String fqdn() {
        if (((PublicIpAddressInner)this.innerModel()).dnsSettings() != null) {
            return ((PublicIpAddressInner)this.innerModel()).dnsSettings().fqdn();
        }
        return null;
    }

    @Override
    public String reverseFqdn() {
        if (((PublicIpAddressInner)this.innerModel()).dnsSettings() != null) {
            return ((PublicIpAddressInner)this.innerModel()).dnsSettings().reverseFqdn();
        }
        return null;
    }

    @Override
    public String ipAddress() {
        return ((PublicIpAddressInner)this.innerModel()).ipAddress();
    }

    @Override
    public String leafDomainLabel() {
        if (((PublicIpAddressInner)this.innerModel()).dnsSettings() == null) {
            return null;
        }
        return ((PublicIpAddressInner)this.innerModel()).dnsSettings().domainNameLabel();
    }

    @Override
    public Accepted<PublicIpAddress> beginCreate() {
        return AcceptedImpl.newAccepted(this.logger, ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getHttpPipeline(), ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (PublicIpAddressInner)this.innerModel()).block(), inner -> new PublicIpAddressImpl(inner.name(), (PublicIpAddressInner)inner, (NetworkManager)this.manager()), PublicIpAddressInner.class, () -> {
            Flux<Indexable> dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
            this.cleanupDnsSettings();
        }, this::setInner, Context.NONE);
    }

    @Override
    public Mono<PublicIpAddress> createResourceAsync() {
        this.cleanupDnsSettings();
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().createOrUpdateAsync(this.resourceGroupName(), this.name(), (PublicIpAddressInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    private void cleanupDnsSettings() {
        PublicIpAddressDnsSettings dnsSettings = ((PublicIpAddressInner)this.innerModel()).dnsSettings();
        if (!(dnsSettings == null || dnsSettings.domainNameLabel() != null && !dnsSettings.domainNameLabel().isEmpty() || dnsSettings.fqdn() != null && !dnsSettings.fqdn().isEmpty() || dnsSettings.reverseFqdn() != null && !dnsSettings.reverseFqdn().isEmpty())) {
            ((PublicIpAddressInner)this.innerModel()).withDnsSettings(null);
        }
    }

    private boolean equalsResourceType(String resourceType) {
        IpConfigurationInner ipConfig = ((PublicIpAddressInner)this.innerModel()).ipConfiguration();
        if (ipConfig == null || resourceType == null) {
            return false;
        }
        String refId = ((PublicIpAddressInner)this.innerModel()).ipConfiguration().id();
        String resourceType2 = ResourceUtils.resourceTypeFromResourceId(refId);
        return resourceType.equalsIgnoreCase(resourceType2);
    }

    @Override
    public boolean hasAssignedLoadBalancer() {
        return this.equalsResourceType("frontendIPConfigurations");
    }

    @Override
    public LoadBalancerPublicFrontend getAssignedLoadBalancerFrontend() {
        if (this.hasAssignedLoadBalancer()) {
            String refId = ((PublicIpAddressInner)this.innerModel()).ipConfiguration().id();
            String loadBalancerId = ResourceUtils.parentResourceIdFromResourceId(refId);
            LoadBalancer lb = (LoadBalancer)((NetworkManager)this.myManager).loadBalancers().getById(loadBalancerId);
            String frontendName = ResourceUtils.nameFromResourceId(refId);
            return (LoadBalancerPublicFrontend)lb.frontends().get(frontendName);
        }
        return null;
    }

    @Override
    public boolean hasAssignedNetworkInterface() {
        return this.equalsResourceType("ipConfigurations");
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((PublicIpAddressInner)this.innerModel()).zones() != null) {
            for (String zone : ((PublicIpAddressInner)this.innerModel()).zones()) {
                zones.add(AvailabilityZoneId.fromString(zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public PublicIPSkuType sku() {
        return PublicIPSkuType.fromSku(((PublicIpAddressInner)this.innerModel()).sku());
    }

    @Override
    public List<IpTag> ipTags() {
        return Collections.unmodifiableList(((PublicIpAddressInner)this.innerModel()).ipTags() == null ? new ArrayList() : ((PublicIpAddressInner)this.innerModel()).ipTags());
    }

    @Override
    public NicIpConfiguration getAssignedNetworkInterfaceIPConfiguration() {
        if (this.hasAssignedNetworkInterface()) {
            String refId = ((PublicIpAddressInner)this.innerModel()).ipConfiguration().id();
            String parentId = ResourceUtils.parentResourceIdFromResourceId(refId);
            NetworkInterface nic = (NetworkInterface)((NetworkManager)this.myManager).networkInterfaces().getById(parentId);
            String childName = ResourceUtils.nameFromResourceId(refId);
            return nic.ipConfigurations().get(childName);
        }
        return null;
    }

    public PublicIpAddressImpl updateTags() {
        return this;
    }

    @Override
    public PublicIpAddress applyTags() {
        return this.applyTagsAsync().block();
    }

    @Override
    public Mono<PublicIpAddress> applyTagsAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((PublicIpAddressInner)this.innerModel()).tags())).flatMap(inner -> {
            this.setInner(inner);
            return Mono.just(this);
        });
    }

    @Override
    public PublicIpAddressImpl withIpTag(String tag) {
        if (((PublicIpAddressInner)this.innerModel()).ipTags() == null) {
            ((PublicIpAddressInner)this.innerModel()).withIpTags(new ArrayList<IpTag>());
        }
        this.ipTags().add(new IpTag().withTag(tag));
        return this;
    }

    @Override
    public PublicIpAddressImpl withIpTag(String tag, String ipTagType) {
        if (((PublicIpAddressInner)this.innerModel()).ipTags() == null) {
            ((PublicIpAddressInner)this.innerModel()).withIpTags(new ArrayList<IpTag>());
        }
        ((PublicIpAddressInner)this.innerModel()).ipTags().add(new IpTag().withTag(tag).withIpTagType(ipTagType));
        return this;
    }

    @Override
    public PublicIpAddressImpl withoutIpTag(String tag) {
        if (tag != null && ((PublicIpAddressInner)this.innerModel()).ipTags() != null) {
            for (IpTag ipTag : ((PublicIpAddressInner)this.innerModel()).ipTags()) {
                if (!tag.equals(ipTag.tag())) continue;
                ((PublicIpAddressInner)this.innerModel()).ipTags().remove(ipTag);
                return this;
            }
        }
        return this;
    }

    @Override
    public PublicIpAddressImpl withIpAddressVersion(IpVersion ipVersion) {
        ((PublicIpAddressInner)this.innerModel()).withPublicIpAddressVersion(ipVersion);
        return this;
    }
}

