/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.TopologyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkWatcher;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Topology;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TopologyParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TopologyResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class TopologyImpl
extends ExecutableImpl<Topology>
implements Topology,
Topology.Definition {
    private Map<String, TopologyResource> resources;
    private final NetworkWatcherImpl parent;
    private TopologyParameters parameters = new TopologyParameters();
    private TopologyInner inner;

    TopologyImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public TopologyParameters topologyParameters() {
        return this.parameters;
    }

    @Override
    public OffsetDateTime createdTime() {
        return this.innerModel().createdDateTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModified();
    }

    @Override
    public Map<String, TopologyResource> resources() {
        return Collections.unmodifiableMap(this.resources);
    }

    private void initializeResourcesFromInner() {
        this.resources = new TreeMap<String, TopologyResource>();
        List<TopologyResource> topologyResources = this.innerModel().resources();
        if (topologyResources != null) {
            for (TopologyResource resource : topologyResources) {
                this.resources.put(resource.id(), resource);
            }
        }
    }

    @Override
    public NetworkWatcher parent() {
        return this.parent;
    }

    @Override
    public TopologyImpl withTargetResourceGroup(String resourceGroupName) {
        this.parameters.withTargetResourceGroupName(resourceGroupName);
        return this;
    }

    @Override
    public TopologyImpl withTargetNetwork(String networkId) {
        this.parameters.withTargetVirtualNetwork(new SubResource().withId(networkId));
        return this;
    }

    @Override
    public TopologyImpl withTargetSubnet(String subnetName) {
        this.parameters.withTargetSubnet(new SubResource().withId(this.parameters.targetVirtualNetwork().id() + "/subnets/" + subnetName));
        return this;
    }

    @Override
    public TopologyInner innerModel() {
        return this.inner;
    }

    @Override
    public Mono<Topology> executeWorkAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().getTopologyAsync(this.parent().resourceGroupName(), this.parent().name(), this.parameters).map(topologyInner -> {
            this.inner = topologyInner;
            this.initializeResourcesFromInner();
            return this;
        });
    }
}

