/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AzureReachabilityReportLatencyInfo;
import java.io.IOException;
import java.util.List;

public final class AzureReachabilityReportItem
implements JsonSerializable<AzureReachabilityReportItem> {
    private String provider;
    private String azureLocation;
    private List<AzureReachabilityReportLatencyInfo> latencies;

    public String provider() {
        return this.provider;
    }

    public AzureReachabilityReportItem withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public String azureLocation() {
        return this.azureLocation;
    }

    public AzureReachabilityReportItem withAzureLocation(String azureLocation) {
        this.azureLocation = azureLocation;
        return this;
    }

    public List<AzureReachabilityReportLatencyInfo> latencies() {
        return this.latencies;
    }

    public AzureReachabilityReportItem withLatencies(List<AzureReachabilityReportLatencyInfo> latencies) {
        this.latencies = latencies;
        return this;
    }

    public void validate() {
        if (this.latencies() != null) {
            this.latencies().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("azureLocation", this.azureLocation);
        jsonWriter.writeArrayField("latencies", this.latencies, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureReachabilityReportItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureReachabilityReportItem deserializedAzureReachabilityReportItem = new AzureReachabilityReportItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provider".equals(fieldName)) {
                    deserializedAzureReachabilityReportItem.provider = reader.getString();
                    continue;
                }
                if ("azureLocation".equals(fieldName)) {
                    deserializedAzureReachabilityReportItem.azureLocation = reader.getString();
                    continue;
                }
                if ("latencies".equals(fieldName)) {
                    List<AzureReachabilityReportLatencyInfo> latencies = reader.readArray(reader1 -> AzureReachabilityReportLatencyInfo.fromJson(reader1));
                    deserializedAzureReachabilityReportItem.latencies = latencies;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureReachabilityReportItem;
        });
    }
}

