/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveSecurityRuleProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityRuleDirection;
import java.io.IOException;
import java.util.List;

public final class EffectiveNetworkSecurityRule
implements JsonSerializable<EffectiveNetworkSecurityRule> {
    private String name;
    private EffectiveSecurityRuleProtocol protocol;
    private String sourcePortRange;
    private String destinationPortRange;
    private List<String> sourcePortRanges;
    private List<String> destinationPortRanges;
    private String sourceAddressPrefix;
    private String destinationAddressPrefix;
    private List<String> sourceAddressPrefixes;
    private List<String> destinationAddressPrefixes;
    private List<String> expandedSourceAddressPrefix;
    private List<String> expandedDestinationAddressPrefix;
    private SecurityRuleAccess access;
    private Integer priority;
    private SecurityRuleDirection direction;

    public String name() {
        return this.name;
    }

    public EffectiveNetworkSecurityRule withName(String name) {
        this.name = name;
        return this;
    }

    public EffectiveSecurityRuleProtocol protocol() {
        return this.protocol;
    }

    public EffectiveNetworkSecurityRule withProtocol(EffectiveSecurityRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String sourcePortRange() {
        return this.sourcePortRange;
    }

    public EffectiveNetworkSecurityRule withSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
        return this;
    }

    public String destinationPortRange() {
        return this.destinationPortRange;
    }

    public EffectiveNetworkSecurityRule withDestinationPortRange(String destinationPortRange) {
        this.destinationPortRange = destinationPortRange;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public EffectiveNetworkSecurityRule withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public EffectiveNetworkSecurityRule withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    public EffectiveNetworkSecurityRule withSourceAddressPrefix(String sourceAddressPrefix) {
        this.sourceAddressPrefix = sourceAddressPrefix;
        return this;
    }

    public String destinationAddressPrefix() {
        return this.destinationAddressPrefix;
    }

    public EffectiveNetworkSecurityRule withDestinationAddressPrefix(String destinationAddressPrefix) {
        this.destinationAddressPrefix = destinationAddressPrefix;
        return this;
    }

    public List<String> sourceAddressPrefixes() {
        return this.sourceAddressPrefixes;
    }

    public EffectiveNetworkSecurityRule withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        this.sourceAddressPrefixes = sourceAddressPrefixes;
        return this;
    }

    public List<String> destinationAddressPrefixes() {
        return this.destinationAddressPrefixes;
    }

    public EffectiveNetworkSecurityRule withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        this.destinationAddressPrefixes = destinationAddressPrefixes;
        return this;
    }

    public List<String> expandedSourceAddressPrefix() {
        return this.expandedSourceAddressPrefix;
    }

    public EffectiveNetworkSecurityRule withExpandedSourceAddressPrefix(List<String> expandedSourceAddressPrefix) {
        this.expandedSourceAddressPrefix = expandedSourceAddressPrefix;
        return this;
    }

    public List<String> expandedDestinationAddressPrefix() {
        return this.expandedDestinationAddressPrefix;
    }

    public EffectiveNetworkSecurityRule withExpandedDestinationAddressPrefix(List<String> expandedDestinationAddressPrefix) {
        this.expandedDestinationAddressPrefix = expandedDestinationAddressPrefix;
        return this;
    }

    public SecurityRuleAccess access() {
        return this.access;
    }

    public EffectiveNetworkSecurityRule withAccess(SecurityRuleAccess access) {
        this.access = access;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public EffectiveNetworkSecurityRule withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public SecurityRuleDirection direction() {
        return this.direction;
    }

    public EffectiveNetworkSecurityRule withDirection(SecurityRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("sourcePortRange", this.sourcePortRange);
        jsonWriter.writeStringField("destinationPortRange", this.destinationPortRange);
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("sourceAddressPrefix", this.sourceAddressPrefix);
        jsonWriter.writeStringField("destinationAddressPrefix", this.destinationAddressPrefix);
        jsonWriter.writeArrayField("sourceAddressPrefixes", this.sourceAddressPrefixes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("destinationAddressPrefixes", this.destinationAddressPrefixes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("expandedSourceAddressPrefix", this.expandedSourceAddressPrefix, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("expandedDestinationAddressPrefix", this.expandedDestinationAddressPrefix, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        return jsonWriter.writeEndObject();
    }

    public static EffectiveNetworkSecurityRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveNetworkSecurityRule deserializedEffectiveNetworkSecurityRule = new EffectiveNetworkSecurityRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.name = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.protocol = EffectiveSecurityRuleProtocol.fromString(reader.getString());
                    continue;
                }
                if ("sourcePortRange".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.sourcePortRange = reader.getString();
                    continue;
                }
                if ("destinationPortRange".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.destinationPortRange = reader.getString();
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List<String> sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.sourcePortRanges = sourcePortRanges;
                    continue;
                }
                if ("destinationPortRanges".equals(fieldName)) {
                    List<String> destinationPortRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.destinationPortRanges = destinationPortRanges;
                    continue;
                }
                if ("sourceAddressPrefix".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.sourceAddressPrefix = reader.getString();
                    continue;
                }
                if ("destinationAddressPrefix".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.destinationAddressPrefix = reader.getString();
                    continue;
                }
                if ("sourceAddressPrefixes".equals(fieldName)) {
                    List<String> sourceAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.sourceAddressPrefixes = sourceAddressPrefixes;
                    continue;
                }
                if ("destinationAddressPrefixes".equals(fieldName)) {
                    List<String> destinationAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.destinationAddressPrefixes = destinationAddressPrefixes;
                    continue;
                }
                if ("expandedSourceAddressPrefix".equals(fieldName)) {
                    List<String> expandedSourceAddressPrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.expandedSourceAddressPrefix = expandedSourceAddressPrefix;
                    continue;
                }
                if ("expandedDestinationAddressPrefix".equals(fieldName)) {
                    List<String> expandedDestinationAddressPrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.expandedDestinationAddressPrefix = expandedDestinationAddressPrefix;
                    continue;
                }
                if ("access".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.access = SecurityRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.priority = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.direction = SecurityRuleDirection.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEffectiveNetworkSecurityRule;
        });
    }
}

